#ifndef MBED_DEBOUNCE_H
#define MBED_DEBOUNCE_H

#include "mbed.h"

class Debounce {

    public:
        Debounce(PinName Pin, int DebounceMS, void (*RiseFunction)(), void (*FallFunction)());
  
    private:
        InterruptIn Input;  
        Ticker InputRiseTick;
        Ticker InputFallTick;
        
        float DebounceTime;
        
        void InputRise();
        void InputFall();
        void RiseTick();
        void FallTick();
        
        void (*FallFunctionPointer)();
        void (*RiseFunctionPointer)();
};

#endif