#include "mbed.h"
#include "Debounce.h"

Debounce::Debounce(PinName Pin, int DebounceMS, void (*RiseFunction)(), void (*FallFunction)()) : Input(Pin)
{
    Input.mode(PullUp); //Set the input to pull up or pull down.
    DebounceTime = (float)DebounceMS / 1000;    //Calculate the debouncetime in seconds.
    Input.rise(callback(this,&Debounce::InputRise));
    Input.fall(callback(this,&Debounce::InputFall));  
    RiseFunctionPointer = RiseFunction;
    FallFunctionPointer = FallFunction;
}

void Debounce::InputRise()
{
    //This function will get called when the input rises.
    InputRiseTick.attach(callback(this, &Debounce::RiseTick), DebounceTime); //Attach a ticker with the desired check time and call the function risetick when time's up.
}

void Debounce::InputFall()
{
    //This function will get called when the input falls.
    InputFallTick.attach(callback(this, &Debounce::FallTick), DebounceTime); //Attach a ticker with the desired check time and call the function risetick when time's up.
}

void Debounce::RiseTick()
{
    //This function will get called after a set time from the last rise event.
    InputRiseTick.detach(); //detach the ticker, as we only use it once.
    if (Input) //Check wheter or not the input is still high.
    {
        //Input is still high after the last rise event.
        (*RiseFunctionPointer)();  //Call the rise function. 
          
    }
}

void Debounce::FallTick()
{
    //This function will get called after a set time from the last fall event.
    InputFallTick.detach(); //detach the ticker, as we only use it once.
    if (!Input) //Check wheter or not the input is still low.
    {
        //Input is still low after the last fall event.
        (*FallFunctionPointer)();   
    }
}