  //Authors: Tom, Nathan, Jeriah 
#include "mbed.h"
#include "RGBSensor.h"
#include "SDFileSystem.h"
#include "SDSave.h"


Timer t;
DigitalOut ledBlue(LED_BLUE);
DigitalOut ledRed(LED_RED);
Serial pc(USBTX,USBRX);

int main() {//main function, calls other files to move temp,RGB,PV,UV all to one managable function
    float lastTime = 0;
    float interval = 0.5;
    ledRed = 0;
    ledBlue = 1;
    wait(0.5);
    RGB_init();
    t.start();
    pc.printf("The timer has started\n\r");
    if (mountSDCard()) {
        return -1; //end program with error status
    }
    pc.printf("The SD card is mounted\n\r");
    createDataFile_testRGB();
    uint16_t rgb[3];
    ledRed = 1;
    while (t.read()<60) {
        if (t.read()>(lastTime+interval))  {
          lastTime=t.read();
          get_rgb(rgb);
          pc.printf("t = %.2f \t red = %d \t green = %d\t blue = %d\r\n",lastTime,rgb[0],rgb[1],rgb[2]);
          writeData_testRGB(lastTime,rgb[0],rgb[1],rgb[2]);//send data to writeData in SDsave.cpp
          //we will get all rgb readings through an array, with the corresponding integers going in order red, green, blue
        }
    }
    closeDataFile();
    ledBlue = 0;
    while (true) {};
} 
      