#include "mbed.h"
#include "N5110.h"
#include "Joystick.h"
#include <math.h>
#include <stdlib.h>

//      rows,cols

//    VCC,SCE,RST,D/C,MOSI,SCLK,LED
//N5110 lcd(p7,p8,p9,p10,p11,p13,p21);  // LPC1768 - pwr from GPIO
//N5110 lcd(p8,p9,p10,p11,p13,p21);  // LPC1768 - powered from +3V3 - JP1 in 2/3 position
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);  // K64F - pwr from 3V3
Joystick joystick(PTB10,PTB11,PTC16);

int main()
{
    int snakex, snakey;
      int foodx,foody;
    // first need to initialise display
    lcd.init();
     joystick.init();
    
    // change set contrast in range 0.0 to 1.0
    // 0.4 appears to be a good starting point
    lcd.setContrast(0.5);

    while(1) {

        // these are default settings so not strictly needed
        lcd.normalMode();      // normal colour mode
        lcd.setBrightness(0.5); // put LED backlight on 50%

        
        lcd.clear();
        
        lcd.drawRect(2,2,75,38,FILL_TRANSPARENT);
        Vector2D mapped_coord = joystick.get_mapped_coord();
        snakex = 35*mapped_coord.x + 42;
        snakey = 23 - 20*mapped_coord.y;

        if (joystick.button_pressed() ) {
            lcd.drawCircle(35,12,3,FILL_BLACK); 
        } else {
            lcd.drawCircle(snakex,snakey,3,FILL_TRANSPARENT);
              lcd.drawRect(snakex-3,snakey-5,3,1,FILL_TRANSPARENT);
            lcd.drawRect(snakex+4,snakey-5,3,1,FILL_TRANSPARENT);
            lcd.drawRect(snakex-1,snakey-1,1,1,FILL_TRANSPARENT);
            lcd.drawRect(snakex+1,snakey-1,1,1,FILL_TRANSPARENT);
            lcd.drawRect(snakex,snakey+2,4,1,FILL_TRANSPARENT);
            }
         
         //
        
         void food(void);
         {
            int i,foodx,foody;
       srand(time(NULL));
        foodx= (rand()%35)+5; // randomise initial  
     foody= (rand()%28)+3; // randomise initial 
    
     for (i = 1; i < 10000;i++)
      { 
      if ( i%20 == 0 ) {  
       lcd.drawCircle(foodx,foody,1,FILL_BLACK); 
   }
     }  
}
      
     
    
     void score();
         {
             int score=0;
             int difx;
             int dify;
             difx=snakex-foodx;
             dify=snakey-foody;
             
        if ( difx<3 &&  dify<3)  { 
       score ++;
       }
       else{
           score =score;
           }
       char bufferscore[14];
       
       sprintf(bufferscore,"%2d",score);
       lcd.printString("score : ", 0,0);
       lcd.printString(bufferscore,50,0);
              
       }   
       
                               
        lcd.refresh();
        wait(0.5);
        
        

    
}
}   
  