#include "cxkEngine.h"

cxkEngine::cxkEngine()
{

}

cxkEngine::~cxkEngine()
{

}

void cxkEngine::init(int CXK_width,int CXK_height,int ball_size,int speed)
{
    // initialise the game parameters
    _CXK_width = CXK_width;
    _CXK_height = CXK_height;
    _ball_size = ball_size;
    _speed = speed;

    // x position on screen - WIDTH is defined in N5110.h
   
    _cxkpx = 80 - _CXK_width;
     _cxkpy = 40 - _CXK_height;// 80 ;40 are the edge of the wall 
     
    // puts CXKs and ball in middle
  
    _cxkp.init(_cxkpx,_cxkpy,_CXK_height,_CXK_width);
    _ball.init(_ball_size,_speed,_direction);
}

void cxkEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _vara = pad.get_vara();
}

void cxkEngine::draw(N5110 &lcd)
{
    // draw the wall basket in the LCD buffer
    
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);//wal
    lcd.drawCircle(6,20,5,FILL_TRANSPARENT);// kuang
    //score
    print_scores(lcd);
    // CXKs
   
    _cxkp.draw(lcd);
    int cxkp_score = _cxkp.get_score();
    // ball
    _ball.draw(lcd);
    if (cxkp_score >= 30) {
        lcd.printString("Congratulations",0,1);  
    lcd.printString(" u win CXK",0,2);
    lcd.printString("GAME OVER",0,4);
    lcd.refresh();
   }     
}

void cxkEngine::update(Gamepad &pad)
{
    check_goal(pad);
    // important to update CXKs and ball before checking collisions so can
    // correct for it before updating the display
  
    _cxkp.update(_d,_vara);
    _ball.update();

    check_wall_collision(pad);
    check_CXK_collisions(pad);
}

void cxkEngine::check_wall_collision(Gamepad &pad)
{
    // read current ball attributes
    Vector2D ball_pos = _ball.get_pos();
    Vector2D ball_velocity = _ball.get_velocity();

    // check if hit top wall
    if (ball_pos.y <= 1) {  //  1 due to 1 pixel boundary
        ball_pos.y = 1;  // bounce off ceiling without going off screen
        ball_velocity.y = -ball_velocity.y;
        // audio feedback
        pad.tone(650.0,0.1);
    }
    else if (ball_pos.x <= 1) {  //  1 due to 1 pixel boundary
        ball_pos.x = 1;  // bounce off ceiling without going off screen
        ball_velocity.x = -ball_velocity.x;
        // audio feedback
        pad.tone(750.0,0.1);
    }
    // check if hit right wall
    else if (ball_pos.x + _ball_size >= (WIDTH-1) ) { // bottom pixel is 47
        // hit bottom
        ball_pos.x = (WIDTH-1) - _ball_size;  // stops ball going off screen
        ball_velocity.x = -ball_velocity.x;
        // audio feedback
        pad.tone(750.0,0.1);
    }
    
    // check if hit bottom wall
    else if (ball_pos.y + _ball_size >= (HEIGHT-1) ) { // bottom pixel is 47
        // hit bottom
        ball_pos.y = (HEIGHT-1) - _ball_size;  // stops ball going off screen
        ball_velocity.y = -ball_velocity.y;
        // audio feedback
        pad.tone(650.0,0.1);
    }

    // update ball parameters
    _ball.set_velocity(ball_velocity);
    _ball.set_pos(ball_pos);
}

void cxkEngine::check_CXK_collisions(Gamepad &pad)
{
    // read current ball attributes
    Vector2D ball_pos = _ball.get_pos();
    Vector2D ball_velocity = _ball.get_velocity();

  
    // see if ball has hit the

    // check cxkp next
    Vector2D cxkp_pos = _cxkp.get_pos();

    // see if ball has hit the CXK 
    if ((ball_pos.y - cxkp_pos.y >= -5) && 
        (ball_pos.y - cxkp_pos.y <= 5) &&
        (ball_pos.x - cxkp_pos.x >= -5) && 
        (ball_pos.x - cxkp_pos.x <=  5)
         ) //right
     {
        // if it has, change the position and reflect x,y  velocity
        ball_pos.x= ball_pos.x + 3;
        ball_pos.y = ball_pos.y + 1;
         ball_velocity.x = -ball_velocity.x ;
      ball_velocity.y = -ball_velocity.y;
        // audio feedback
        pad.tone(1000.0,0.1);
        pad.tone(900.0,0.1);
        pad.tone(800.0,0.1);
    }
    
        // write new attributes
    _ball.set_velocity(ball_velocity);
    _ball.set_pos(ball_pos);
}

void cxkEngine::check_goal(Gamepad &pad)
{
    Vector2D ball_pos = _ball.get_pos();
    Vector2D cxkp_pos = _cxkp.get_pos();
    // cxkp has scored if the ball in the basket
    if (
        (ball_pos.y <= 25) &&
        (ball_pos.y >= 15) && 
        (ball_pos.x <= 6) && 
        (ball_pos.x >= 1)  
        
     ) {
        _cxkp.add_score();
        _ball.init(_ball_size,_speed,_direction);
        pad.tone(1500.0,0.5);
        pad.leds_on();
        wait(0.5); // wiat show the goal 
        pad.leds_off();
    }
   
}

void cxkEngine::print_scores(N5110 &lcd)
{
    // get scores from CXKs
   
    int cxkp_score = _cxkp.get_score();

    // print to LCD i
    // font is 8 wide, so leave 4 pixel 2e from middle assuming two digits
    char buffer2[14];
    sprintf(buffer2,"%2d",cxkp_score);
    lcd.printString(buffer2,40 ,1);
   
}

