#ifndef BALL_H
#define BALL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "CXK.h"

/** Ball Class
* @brief Controls the ball in Ubeautiful CXK game 
* @author Zhang Xinyu
* @school EE of  SWJTU &leeds joint school
* @date  MAY  2019
*/ 

class Ball
{

public:
   /** Constructor */
    Ball();
    
    /** Destrctor */
    ~Ball();
    
    /** Set the ball init  
     * @param the value  of init (size,speed, direction)
     */
     void init(int size,int speed, int direction);
     
     
       /** Set the balldraw 
    * @ details  lcd.drawCircle(_x,_y,_size,FILL_BLACK);
   * @ param value that updated (_x,_y, _size)
    */
    void draw(N5110 &lcd);
    
    
    /** Set the update
      * @details updated the _x,_y value by speed means move the ball
     */
    void update();
    
    /// accessors and mutators
    
     /** Set the balldraw 
    * @ details set the value of veocity LCD cooresponding v = {_velocity.x,_velocity.y};
   * @ param value that updated (v)
   * @ returns v
    */
    void set_velocity(Vector2D v);
    Vector2D get_velocity();
    Vector2D get_pos();
    
     /** Set the balldraw 
    * @ details set the value of position of LCD cooresponding p= {x,y};
   * @ param value that updated (p)
   * @ returns p
    */
    void set_pos(Vector2D p);
    
private:

    Vector2D _velocity;
    int _size;
    int _x;
    int _y;
    int _direction;
};
#endif