#ifndef cxkEngine_H
#define cxkEngine_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Ball.h"
#include "CXK.h"


/** cxkEngine Class
* @brief the diagram of the ball and others 
* @author Zhang Xinyu 201090208
* @brief school EE of  SWJTU &leeds joint school
* @date  MAY  2019
*/ 

class cxkEngine
{

public:

/** Constructor */
    cxkEngine();
    
    /** Destrctor */
    ~cxkEngine();

 /** Set the cxkEngineinit  
       * @ param value of the cxk feature of the CXK file (CXK_width, CXK_height)
        * @ param value of the ball size of the ballfile (ball_size)
         * @ param value of the move speed of the CXKand ball file (speed)
    */
    void init(int CXK_width,int CXK_height,int ball_size,int speed);
    
    /** Set the cxkEread_Iinput
      * @ details use CXK and BAll to read the value of direction and maganitude of joystick
    */
    void read_input(Gamepad &pad);
    

    /** Set the cxkEupdate 
      * @ details updated the d and vara from the read_input
    */
    void update(Gamepad &pad);
    
     /** Set the CXKdraw  
       * @ param  the score player get (cxkp_score)
       * @ details draw the wall and basket to the game
       */
    void draw(N5110 &lcd);
    
private:

    void check_wall_collision(Gamepad &pad);
    void check_CXK_collisions(Gamepad &pad);
    void check_goal(Gamepad &pad);
    void print_scores(N5110 &lcd);
    
   
    CXK _cxkp;
     
    int _CXK_width;
    int _CXK_height;
    int _ball_size;
    int _speed;
    int _direction;
    
    // xy positions of theCXKs
///////// 
    int _cxkpx;
    int _cxkpy;
    
    Ball _ball;
    
    Direction _d;
    float _vara;

};

#endif