#include "CXK.h"

// nothing doing in the constructor and destructor
CXK::CXK()
{

}

CXK::~CXK()
{

}

void CXK::init(int x,int y,int height,int width)
{
    _x = 67 - width/2;  
    _y = 25 - height/2;  // y depends on height of screen and height of CXK
    _height = height;
    _width = width;
    _speed = 1;  // default speed
    _score = 0;  // start score from zero

}

void CXK::draw(N5110 &lcd)
{
    // draw CXK in screen buffer. 
  lcd.drawCircle(_x,_y,3,FILL_TRANSPARENT);
              lcd.drawRect(_x-3,_y-5,4,1,FILL_TRANSPARENT);
            lcd.drawRect(_x+4,_y-5,4,1,FILL_TRANSPARENT);
            lcd.drawRect(_x-1,_y-1,1,1,FILL_TRANSPARENT);
            lcd.drawRect(_x+1,_y-1,1,1,FILL_TRANSPARENT);
            lcd.drawRect(_x,_y+2,4,1,FILL_TRANSPARENT);
}


void CXK::update(Direction d,float vara)
{
    _speed = int(vara*10.0f);  // scale is arbitrary, could be changed in future

    // update y value depending on direction of movement
    // North is decrement as origin is at the top-left so decreasing moves up
    if (d == N) {
        _y-=_speed;
    } else if (d == S) {
        _y+=_speed;
    } else if (d == E) {
        _x+=_speed;
    } else if (d == W){
        _x-=_speed; 
        }

    
    // check the y origin to ensure that the CXK doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_y > HEIGHT - _height - 1) {
        _y = HEIGHT - _height - 1;
    }
    
    if (_x < 1) {
        _x = 1;
    }
    if (_x > WIDTH - _width-3 ) {
        _x = WIDTH - 3;
    }
      
}

void CXK::add_score()
{
    _score++;
}
int CXK::get_score()
{
    return _score;
}

Vector2D CXK::get_pos() {
    Vector2D p = {_x,_y};
    return p;    
}