///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "cxkEngine.h"

#ifdef WITH_TESTING
# include "tests.h"
#endif

/* ELEC2645 Embeeded System Project 
School of Elctronic & Electrical Enigneering 
University of Leeds 

Name : Zhang Xinyu
Username : Zhang Xin yu
Student ID number : 201090208
Date : 2019. 05.6

*/


/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float vara; // vara is the magnitude of the joystich
};

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
cxkEngine basketball;

///////////// prototypes define the void ///////////////
void init();
void update_game(UserInput input);
void render();// main contain
void welcome();
void over();

///////////// functions ////////////////
int main()
{

    int fps = 8;  // frames 8k per second

    init();     // initialise and then display welcome screen...
    welcome();  // waiting for the user to start
    
    render();  // first draw the initial frame 
    wait(1.0f/fps);  // and wait for one frame period


    // game loop - read input, update the game state and render the display
    while (1) {
        basketball.read_input(pad);
        basketball.update(pad);
        render();
        wait(1.0f/fps);
    }
}

// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
    // initialise the game with correct ball and paddle sizes
    basketball.init(2,8,2,3);

}

// this function draws each frame on the LCD
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    basketball.draw(lcd);
    lcd.refresh();
}

// simple splash screen displayed on start-up
void welcome() {
    
    lcd.printString(" U beautiful",0,1);  
    lcd.printString("zhang xinyu",0,2);
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}