#ifndef CXK_H
#define CXK_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** CXK Class
* @brief defined the cxk and the add score funvtion
* @author Zhang Xinyu
* @brief school EE of  SWJTU &leeds joint school
* @date  MAY  2019
*/ 

class CXK
{
public:
/** Constructor */
    CXK();
    
    /** Destrctor */
    ~CXK();
    
      /** Set the CXKinit  
       * @ param value that updated (x,y,height, width)
       * @ details the (x,y) mean the centre point figure of cxk ,height meansheight of CXK
    */
    void init(int x,int y,int height,int width);
    
    
      /** Set the CXKdraw  
       * @ param value that updated _x is x, _y is y (_x,_y)
       */
    void draw(N5110 &lcd);
    
     /** Set the CXKupdate  
       * @ param  drection of movement (direction)
       * @ vara means magenitude of the jiysticks 
       * @ details  North is decrement as origin is at the top-left so decreasing moves up 
    */
    void update(Direction d,float vara);
    
    /** Set the CXKscore
       * @ param  the score of the game palyer (score)
       * @ details add the score when meet the order of the code
    */
    void add_score();
    
    /** Set the CXKscore
       * @ returns the score (score)
       * @ details score = 0
       */
    int get_score();
    
    
    Vector2D get_pos();

private:

    int _height;
    int _width;
    int _x;
    int _y;
    int _speed;
    int _score;

};
#endif