#include "mbed.h"
#include "manchester.h"

DigitalIn signal(p7);
Serial pc(USBTX, USBRX);
Timer timer;
Timeout timeout;
int datal[] = {1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0};
bool notTimedOut;

manchester::manchester()
{
}

int manchester::decode()
{

    int previous,current,begin,end=0;
    int time=0;
    int i = 0;
    int datas[] = {1,1,1,1,0,0,0,0,0,0};
    notTimedOut = true;
    timer.start();
    while(i< DELAY) {
        previous = current;
        current = signal.read();
        if(current != previous) {
            i=0;
        }
        i++;
        wait_us(100);
    }
    i = 0;
    timeout.attach(callback(this,&manchester::isTimedOut), 3);
    while(i<4 && notTimedOut) {
        end = begin;
        previous = current;
        current = signal.read();
        if(current<previous) {
            begin = timer.read_us();
            if(end != 0) {
                time +=(begin - end);
            }
            i++;
        }
    }
    if(notTimedOut == true) {
        float atime=((float)time/3000000);
        i=4;
        wait(atime/2);
        while(i<10) {
            int x = signal.read();
            wait(atime/2);
            int y = signal.read();
            wait(atime/2);

            if(x<y) {
                datas[i]=0;
            } else if(x>y) {
                datas[i]=1;
            }
            i++;
        }
        wait(1);
        pc.printf("\n\raverage time is = %f s\n\r",atime);
        pc.printf("with frequency %f\n\r",1/atime);
        pc.printf("data is:");
        int direction = getDirection(datas);
        bool stopcode =getStopCode(datas);
        for(int j = 0; j<10; j++) {
            printf("%d",datas[j]);
        }
        printf("with direction:%d\r\n",direction);
        timer.stop();
        if(stopcode==true){
            return direction;
        }
        else{
            return 5;
        }
        //return direction;
    } else {
        printf("timed out\r\n");
        return 4;
    }
//}
}

int manchester::getDirection(int* data)
{
    int direction;
    if(data[4]==0) {
        if(data[5]==0) {
            direction = 0;
        } else {
            direction = 1;
        }
    } else {
        if(data[5]==0) {
            direction = 2;
        } else {
            direction = 3;
        }
    }
    return direction;
}

void manchester::isTimedOut()
{
    notTimedOut = false;
}

bool manchester::getStopCode(int* data)
{
    bool code= true;
    int test[] = {0,0,0,0,0,0,0,0,0,1};
    for(int i = 6; i < 10; i++){
        if(data[i]==test[i]){
            code = true;
        }
        else{
            code = false;
            break;
        }
    }    
    return code;
}