#include "mbed.h"
#include "slave.h"
#include "C12832A1Z.h"
#include "led.h"
#include "LM75B.h"
#include <string.h>
#include "EthernetInterface.h"

LM75B sensor(p28,p27);
Serial slavepc(USBTX, USBRX);
led mijnobject;
C12832A1Z slaveLCD(p5, p7, p6, p8, p11);

PwmOut r(p23);
PwmOut g(p24);
PwmOut b(p25);

AnalogIn p1(p19);
AnalogIn p2(p20);

PwmOut spkr(p26);

float freq[]={0,110,110,110,98,130,110,98,130,110,165,165,165,175,130,104,98,130};
float length[]={0,480,480,480,360,120,480,360,120,960,480,480,480,360,120,480,360,120};
float delay[]={0,100,100,100,75,100,100,75,100,100,100,100,100,75,100,100,75,100};

slave::slave(){
    
}

void slave::startSlave(const char *ip){
        EthernetInterface eth;
        eth.init(ip, "255.255.255.0", "192.168.0.1");
        eth.connect();
        slavepc.printf("ip = %s\n\r",eth.getIPAddress());
        slavepc.printf("gateway = %s\n\r",eth.getGateway());
        slavepc.printf("mask = %s\n\r",eth.getNetworkMask());
    
        UDPSocket server;
        server.bind(4000);
        
        Endpoint client;
        
        while (true){
            char slaveBuffer[512]={NULL};
            slavepc.printf("\n\rWaiting for UDP packet...\n\r");
            int n = server.receiveFrom(client, slaveBuffer, sizeof(slaveBuffer));
            slaveBuffer[n] = '\0';
            
            slavepc.printf("Received packet from: %s\n\r", client.get_address());
            slavepc.printf("Packet contents : '%s'\n\r",slaveBuffer);
            
            slavepc.printf("Sending Packet back to Client\n\r");
            server.sendTo(client, getResponse(slaveBuffer,eth.getIPAddress()), 512);
        }
}    
char *slave::getResponse(const char *buffer,const char *ip){
    char *request = strtok((char*)buffer," ");//{buffer[0],buffer[1],buffer[2],'\0'};
    char *resource = strtok(NULL," ");
    slavepc.printf("\n\rresource =%s\n\r",resource);
    char tempbuffer[512];
    if(strcmp(request,"GET")==0){
        if(strcmp(resource,"/temperature")==0){
            sprintf(tempbuffer,"ACK 2.05 %3s %3.3f", getID(ip), getTemp());
            slavepc.printf("%s\n\r",tempbuffer);
        }
        else if(strcmp(resource,"/potentiometer")==0){
            slavepc.printf("%f",getPot());
            sprintf(tempbuffer,"ACK 2.05 %3s %3d", getID(ip),int(255* getPot()));
            slavepc.printf("%s\n\r",tempbuffer);
        }
        else{
            sprintf(tempbuffer,"ACK 4.00 %3s",getID(ip));
        }
    }
    else if(strcmp(request,"PUT")==0){
        if(strcmp(resource,"/BUZZER")==0){            
            putBuzzer(atoi(strtok(NULL," -_")),atoi(strtok(NULL," -_")));
            sprintf(tempbuffer,"ACK 2.04 %3s",getID(ip));
        }
        else if(strcmp(resource,"/LED")==0){
            putLED(strtok(NULL,'\0'));
            sprintf(tempbuffer,"ACK 2.04 %3s",getID(ip));
        }
        else if(strcmp(resource,"/LCD")==0){
            putLCD(strtok(NULL,'\0'));
            sprintf(tempbuffer,"ACK 2.04 %3s",getID(ip));
        }
        else{
            sprintf(tempbuffer,"ACK 4.00 %3s",getID(ip));
        }
    }
    else{
        sprintf(tempbuffer,"ACK 4.00 %3s",getID(ip));
    }
    return tempbuffer;
}

float slave::getTemp(){
    return sensor.read();
}

float slave::getPot(){
    return p1.read();
}

void slave::putLCD(char *str){
    slaveLCD.cls();
    slaveLCD.locate(0,3);
    slaveLCD.printf("%s",str);
}

void slave::putLED(char *color){
        led::COLOR testcolor = mijnobject.getCOLOR(color);
        r=testcolor.redValue;
        g=testcolor.greenValue;
        b=testcolor.blueValue;
}

void slave::putBuzzer(int start,int einde){
    for(start; start<einde+1;++start){
        spkr.period(1/freq[start]);
        spkr=0.5;
        wait(length[start]/1000);
        spkr=0;
        wait(delay[start]/1000);
    } 
}

char *slave::getID(const char* ip){
    char temp[14];
    sprintf(temp,"%13s",(char*)ip);
    char *temp2;
    temp2 = strtok(temp,".");
    temp2 = strtok(NULL,".");
    temp2 = strtok(NULL,".");
    char *id = strtok(NULL,'\0');
    return id;
}