#include "mbed.h"
#include "master.h"
#include <string.h>
#include "EthernetInterface.h"

Serial masterpc(USBTX, USBRX);

master::master(){
    
}

void master::startMaster(const char* ip){
        EthernetInterface eth;
        eth.init(ip, "255.255.255.0", "192.168.0.1");
        eth.connect();
        masterpc.printf("ip = %s\n\r",eth.getIPAddress());
        masterpc.printf("gateway = %s\n\r",eth.getGateway());
        masterpc.printf("mask = %s\n\r",eth.getNetworkMask());
        UDPSocket sock;
        
        while(true){
            char masterBuffer[512]={NULL};
            typeRequest(masterBuffer);
            
            char ipArray[14]={NULL};
            typeIp(ipArray);
        
            sock.init();
            const char *ECHO_SERVER_ADDRESS = ipArray;
            Endpoint echo_server;
            echo_server.set_address(ECHO_SERVER_ADDRESS,4000);
            masterpc.printf("\n\rSending \"%s\" to IPAddress :%s\n\r",masterBuffer,ECHO_SERVER_ADDRESS);
            sock.sendTo(echo_server,masterBuffer,sizeof(masterBuffer));
            
            int n = sock.receiveFrom(echo_server, masterBuffer, sizeof(masterBuffer));
            masterBuffer[n] = '\0';
            masterpc.printf("Received message from server: '%s'\n\r", masterBuffer);
            sock.close();
        }
}

void master::typeRequest(char* buffer){
    masterpc.printf("type for request:\n\r");
    for(int i = 0;i<512;i++){
        char key = masterpc.getc();
        if(key != 13){
            masterpc.putc(key);
            buffer[i]=key;
        }
        else{
            buffer[i]='\0';
            break;
        }
    }
}

void master::typeIp(char* buffer){
    masterpc.printf("\n\rinsert ip address to send to:\n\r  ");
    for(int i = 0;i<14;i++){
        char key = masterpc.getc();
        if(key != 13){
            masterpc.putc(key);
            buffer[i]=key;
        }
        else{
            buffer[i]='\0';
            break;
        }
    }
}