#include "mbed.h"
#include <string.h>
#include "slave.h"
#include "master.h"
#include "EthernetInterface.h"


BusIn joy(p15,p12,p13,p16);
DigitalIn select(p14);
Serial pc(USBTX, USBRX);

master master;
slave slave;

char *ip;
int mode=0;

void initialize();

int main() {
    initialize();
    //master mode
    if(mode == 1){
        master.startMaster(ip);
    }
    
    //slave mode
    if(mode == 2){
        slave.startSlave(ip);
    }
    
}

/**Initializes the mbed by asking the user to insert a ID that can range from 100 to 110.
  *Function also ask for the user to choose if the mbed should be in slave mode or in master mode
  */
void initialize(){
    pc.printf("insert ipadress ranging between 100 and 110:\n\r");
    char id[4];
    char firstID[] = "192.168.0.";
    pc.scanf("%3s",id);
    ip = strcat(firstID,id);
    pc.printf("full IPadress is: %s\n\r",ip);
    pc.printf("choose mode with joystick: up = master / down = slave\n\r");
    while(select == 0 || mode==0){
        if(joy.read()==1 && mode !=1){mode = 1;pc.printf("mode set to master\n\r");while(joy.read()==1);}//set mode in master.
        if(joy.read()==2 && mode !=2){mode = 2;pc.printf("mode set to slave\n\r");while(joy.read()==2);}//set mode in slave
    }
    pc.printf("ok\n\r");
}