#include "mbed.h"
#include "HIDScope.h"
#include "encoder.h"


//pinverdeling en naamgeving variabelen
Encoder motor1(D13,D12);
Encoder motor2(D11,D10);        // telt pulsen bij verdraaiing en zet dit om in de rotatiehoek
PwmOut led(D9);
DigitalOut motor1_direction(D4);
PwmOut motor1_speed(D5);
DigitalOut motor2_direction(D7); // motor direction
PwmOut motor2_speed(D6);         // motor speed
DigitalIn button_1(PTC6);       // counterclockwise
DigitalIn button_2(PTA4);       // clockwise
HIDScope scope(2);              // Hidscope met 2channels

const int pressed = 0;     //signaal(beweging) bij indrukken

void move_motor1_ccw()
{
    motor1_direction = 1;
    motor1_speed = 1;
}

void move_motor2_ccw ()   //beweging ccw motor 2, signaal van linker bovenbeen
{
    motor2_direction = 0;
    motor2_speed = 1;
}

void move_motor1_cw()
{
    motor1_direction = 0;
    motor1_speed = 0.2;
    }

    void move_motor2_cw (){ // beweging cw motor 1, signaal van rechter bovenbeen
        motor2_direction = 1;
        motor2_speed = 0.2;
    }

    void read_encoder1() {
        scope.set(0,motor1.getPosition());
        led.write(motor1.getPosition()/100.0);
        scope.send();
        wait(0.2f);
    }

    void read_encoder2 () { // aflezen van encoder via hidscope??
        scope.set(1,motor2.getPosition());
        led.write(motor2.getPosition()/100.0);
        scope.send();
        wait(0.2f);
    }

    void move12() { // beweging van motor 2 cw of ccw d.m.v. button 3 of 4

        if (button_1 == pressed) {
            move_motor1_cw ();
            move_motor2_cw();
            }
        else if (button_2== pressed) {
            move_motor1_ccw();
            move_motor2_ccw ();
            }
        else {
            motor1_speed = 0;
            motor2_speed = 0;
        }
    }

//uitvoeren van script
    int main() {
        while (true) {

            read_encoder1();
            read_encoder2();
            move12();
        }

    }
