#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"

EthernetInterface eth;
RawSerial pc(USBTX, USBRX); // tx, rx

int main()
{
    pc.baud(9600);
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s \n\r", eth.getIPAddress());
    TCPSocketConnection socket;
    
    socket.connect("httpbin.org", 80);
    
    char http_cmd[] = "GET /get?helloworld HTTP/1.0\r\n\r\n";
    socket.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = socket.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    printf("DONE!\n");
      // Initialize ifttt object, add up to 3 optional values, trigger event.
    IFTTT ifttt("hellowordmbed","ExqSjQiwzZINRMFTOgo--", &socket); // EventName, Secret Key, socket to use
    ifttt.addIngredients("this is awesome","test-ing","data!!!");     // 3 optional Values to send along with trigger.
    ifttt.trigger();

    // Send data using GET
    ifttt.addIngredients("Sending","GET","data");
    ifttt.trigger(IFTTT_GET);

    // Send Data using POST
    ifttt.addIngredients("Sending","POST","things");
    ifttt.trigger(IFTTT_POST);

   
    
    socket.close();
    
    eth.disconnect();
    
   while(1) {
    }
}
extern "C" void mbed_mac_address(char *mac)
{
    mac[0] = 0xD4;
    mac[1] = 0x3D;
    mac[2] = 0x7E;
    mac[3] = 0x2C;
    mac[4] = 0x7E;
    mac[5] = 0x1C;
};
