#include "files.h"
#include "alp.h"


revision_t revision = {
    .nw_stat = 0,
    .nw_seq = 255,
    // These data are parsed to identify the device
    .manufacturer_id    = __MANUFACTURER_ID__,
    .device_id          = __DEVICE_ID__,
    .fw_version.fw_id   = __FW_ID__,
    .fw_version.major   = __FW_MAJOR__,
    .fw_version.minor   = __FW_MINOR__,
    .fw_version.patch   = __FW_PATCH__,
    .fw_version.hash    = __FW_HASH__,
    .hw_version         = __HW_ID__,
    .fs_crc             = 0,
};

alarm_data_t alarm_data = {
    .nw_stat = 0,
    .nw_seq = 255,
    .status = true,
};

alarm_cmd_t alarm_cmd = {
    .cmd = 0,
};

temp_data_t temp_data = {
    .nw_stat = 0,
    .nw_seq = 255,
    .value = 0,
};

const d7_file_header_t revision_device_fh = {
    .access_class = ACCESS_CLASS_GW,
    .notify = true,
    .file_size = REVISION_DEVICE_FILE_SIZE,
    .file_id = REVISION_DEVICE_FILE_ID,
};

const d7_file_header_t alarm_data_fh = {
    .access_class = ACCESS_CLASS_GW,
    .notify = true,
    .file_size = ALARM_DATA_FILE_SIZE,
    .file_id = ALARM_DATA_FILE_ID,
};

const d7_file_header_t alarm_cmd_fh = {
    .access_class = ACCESS_CLASS_GW,
    .notify = false,
    .file_size = ALARM_CMD_FILE_SIZE,
    .file_id = ALARM_CMD_FILE_ID,
};

const d7_file_header_t temp_data_fh = {
    .access_class = ACCESS_CLASS_GW,
    .notify = true,
    .file_size = TEMP_DATA_FILE_SIZE,
    .file_id = TEMP_DATA_FILE_ID,
};