#ifndef _FILES_H_
#define _FILES_H_

#include "mbed.h"
#include "alp.h"

#define TYPEDEF_STRUCT_PACKED   typedef struct __attribute__((packed))

/*
These data are user defined and will be used by the dash7board
to identify the device
*/

#define __MANUFACTURER_ID__         0x15070000 // Identify the manufacturer
#define __DEVICE_ID__               0x89ABCDEF // Identify the device type

#define __FW_ID__                   0x01       // Firmware ID
#define __HW_ID__                   0x01520C02 // Hardware ID

// Firmware version
#define __FW_MAJOR__                0x02
#define __FW_MINOR__                0x03
#define __FW_PATCH__                0x0045
#define __FW_HASH__                 0x86605dba

// Alarm data structure
TYPEDEF_STRUCT_PACKED
{
    uint8_t  nw_stat;
    uint8_t  nw_seq;
    uint8_t  status; // Alarm state true/false
} alarm_data_t;

#define ALARM_DATA_FILE_ID          (224)
#define ALARM_DATA_FILE_SIZE        ((uint16_t) sizeof(alarm_data_t))

// Alarm data structure
TYPEDEF_STRUCT_PACKED
{
    uint8_t  cmd; // Alarm state true/false
} alarm_cmd_t;

#define ALARM_CMD_FILE_ID           (211)
#define ALARM_CMD_FILE_SIZE         ((uint16_t) sizeof(alarm_cmd_t))


// Alarm data structure
TYPEDEF_STRUCT_PACKED
{
    uint8_t  nw_stat;
    uint8_t  nw_seq;
    int8_t   value; // Temperature value in °C
} temp_data_t;

#define TEMP_DATA_FILE_ID           (226)
#define TEMP_DATA_FILE_SIZE         ((uint16_t) sizeof(temp_data_t))


extern revision_t   revision;
extern alarm_data_t alarm_data;
extern alarm_cmd_t  alarm_cmd;
extern temp_data_t  temp_data;

extern const d7_file_header_t revision_device_fh;
extern const d7_file_header_t alarm_data_fh;
extern const d7_file_header_t alarm_cmd_fh;
extern const d7_file_header_t temp_data_fh;

#endif // _FILE_SYS_H_
