/* mbed yMOTOR Library
 * Copyright (c) 2015 Jean92, https://developer.mbed.org/users/Jean92/
 */
 /**
 * @file    yMOTOR.cpp
 * @brief   Class 'yMOTOR'
 * @version V0.7
 * @date    Sept-2015
 * @note    by Jean92 \n
 *          Controlleur pour Pont-H (MC33886)" \n
 *
 */
#include "mbed.h"
#include "yMOTOR.h"

/** Constructeur de la class yMOTOR */
yMOTOR::yMOTOR(PinName pwm, PinName av, PinName ar):
                _pwm(pwm), _av(av), _ar(ar) {
     // herite de PWM et DO
     // init PWM, init deadband
    this->m_DB = yDB_def;
    _pwm.period(yPeriod_def);
    _pwm = 0.0;
    
    // moteur a l'arret
    _ar = 0;
    _av = 0;
    this->m_run = 0;

    // memory of speed
    this->m_speed = 0.0;
}

/** Traiter le changement de vitesse */
void yMOTOR::Speed(float speed) {
    if (this->m_run) {              // moteur running?
        if (abs(speed) < this->m_DB) {     // oui, consigne suffisante?
            _ar = 0;                    // non, les 2 cdes à zéro
            _av = 0;
            _pwm = 0.0;                 // reset PWM
            this->m_speed = 0.0;        // memoriser vitesse nulle
        }
        else {                             // oui, en dehors de la bande morte
            _av = (speed > this->m_DB);    // en avant
            _ar = (speed < -this->m_DB);   // ou en arriere
            _pwm = abs(speed);             // a la vitesse demandée
            this->m_speed = speed;         // memoire vitesse
        }
    } 
} 

/** Changer la periode de PWM */
void yMOTOR::Period(float seconds) {
    _pwm.period(seconds);
}

/** Change DeadBand */
void yMOTOR::DeadBand(float db) {
    this->m_DB = db;
}

/** Marche/Arret request */
void yMOTOR::MarArr(int mararr) {
    if (mararr == yMARCHE) {
        this->m_run = 1;        // memoriser l'état
        Speed(this->m_speed);   // appliquer la vitesse demandée
    }
    else if (mararr == yARRET) {
        _ar = 0;                // mettre les 2 cdes a zero
        _av = 0;                // ==> arret rotation
        this->m_run = 0;        // memoriser l'état
                                // sans changer memoire vitesse
    }
}

/** Etat marche (running state) */
bool yMOTOR::Run() {
    //return (abs(this->m_speed) > yDB_def);
    //return (_av != _ar);        //Marche si av et ar non nul
    return this->m_run;     // repondre de mémoire!
}

/** Vitesse effective */
float yMOTOR::Velocity() {
    return this->m_speed;   
}

/** Destructeur */
yMOTOR::~yMOTOR()
{ // ne rien mettre ici
}
/* mbed yMOTOR Library
 * Copyright (c) 2015 Jean92, https://developer.mbed.org/users/Jean92/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 // MIT Licence
 
/**
 * @note \n
 *         That's all folks!
 */
 