/* mbed yMOTOR Library
 * Copyright (c) 2015 Jean92, https://developer.mbed.org/users/Jean92/
 */
 
/**
 * @file    yMOTOR.h
 * @brief   Header de la classe 'yMOTOR'
 * @version V0.7
 * @date    Sept-2015
 * @note    by Jean92 \n
 *          Controlleur pour Pont-H (MC33886)"
 *
 */

#ifndef DEF_yMOTOR_H
#define DEF_yMOTOR_H

#include "mbed.h"

#define yARRET 0
#define yMARCHE 1
#define yDB_def 0.01        // dead band around 0.0 for nul speed
#define yPeriod_def 0.5     // en seconds

class yMOTOR
{
public:     /// Methodes (visibles par tous!)

    /** Interface de controle du moteur
     * @param pwm (Pwmout, vitesse variable)
     * @param av  (DigitalOut, marche avant)
     * @param ar  (DigitalOut, marche arriere)
     */
    yMOTOR(PinName pwm, PinName av, PinName ar);        /// Constructeur par defaut
    ~yMOTOR();                                          /// Destructeur
    
    /** Vitesse request
     * @param speed (float normalised [-1.0,+1.0]
     * negative ==> reverse, positive ==> forward
     */
    void Speed(float speed);
    
    /** PWM duty cycle periode in seconde
     * wrapper for PwmOut::period()
     * @param seconds (PWM duty cycle)
     */
    void Period(float seconds);

    /** Change DeadBand
     * @param db
     * modify the default dead band (around 0.0 not action)
     */
    void DeadBand(float db);
    
    /** Marche/Arret request
     * yARRET ==> av = ar = 0
     * yMARCHE ==> av & ar = sign of speed
     */
    //void mararr(int mararr = yARRET);
    void MarArr(int mararr);
    
    /** Etat marche (running state)
     */
    bool Run();
    
    /** Vitesse effective
     * float normalised [-1.0,+1.0]
     * negative ==> reverse, positive ==> forward
     */
    float Velocity();
    
private:    /// Attributs - m_membres (visibles par les methodes)
    float m_speed;  //spedd memory
    bool m_run;     //running memory
    float m_DB;     //deadband

protected:  /// Attibuts (accessibles seulement via les methodes)
    PwmOut _pwm;        // par heritage
    DigitalOut _av;
    DigitalOut _ar;
        
};

#endif

/* mbed yMOTOR Library
 * Copyright (c) 2015 Jean92, https://developer.mbed.org/users/Jean92/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 // MIT Licence

/**
 * @note \n
 * That's all folks!
 */
