/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_Portada
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         This module contains user's application code.
**   Componentes     : Timer, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocodades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**          - Marcelo Padron Javier
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 22/10/2019
**                   
**                     
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
#define Ticker_Rate     1000            // Tiempo del Ticker
////////////////////////////////////////// Definimos las notas notas musicales y su frecuencia.
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/ 
DigitalOut   verde  (LED1);    // NC       (Green_Led)
BusOut       Torreta(PB_4,PB_3,PA_15,PA_12,PA_11,PA_10,PA_9,PA_8); // 
DigitalOut   Led_Monitor (PB_1);         // Led monitor de la Tarjeta STM32F103C8
Ticker       Barrido;    
PwmOut       Buzzer(PB_11);
Serial       terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial     terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
uint8_t SecuenciaA[]={          //Secuencia de luces A
        0xC3,0x3C,0xC3,0x3C,0xC3,0x3C,0xC3,0x3C,
        0xC3,0xFF,0xC3,0xFF,0xC3,0xFF,0xC3,0xFF,
        0xC3,0xFF,0xC3,0xFF,0xC3,0xFF,0xC3,0xFF, 
        };
uint16_t No_SecuenciasA=24;      
uint16_t A=0;                    
uint16_t delayA=100;             
uint16_t contadorA=0;           // Velocidad de Transmisión (Bauds)

/*
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Portada();
void Seleccion();
void Setup(void);  
void Barrido_OnInterrupt(void);  
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                   // Inicialización de variables, puertos e interrupciones     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
Setup();            // Inicialización del sistema

Portada();          //Mandar a llamar a la funcion Portada.
Seleccion();        //Mandar a llamar a la funcion Seleccion.
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{   
    terminal.baud(115200);              // Se configura la velocidad de transmisión e inicia la comunicación serial.  
}    
void Portada()//Funcion Portada
{
    terminal.printf("\n\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0101  0101  0101  0101 0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\r\t\e[1;32m01    01      01    010 010  01        0   0  1  01    0  1   10  01    010  10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m0101  0101    01    01 1 10  0101     1    0101  01    0101   10  0101  01 1 10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m01      01    01    01   10  01      0     0  1  01    0  1   10  01    01  010  01    0  1\e[0m"); 
    terminal.printf("\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0  1  0101  0  1   10  0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\n\r\t\e[1;32m       \'NUESTROS COLORES VERDE \e[0m\e[1;37mY BLANCO, POR QUE EL\e[0m\e[1;31m ROJO LO LLEVAMOS EN LA SANGRE!!!\'\e[0m\n\n");
    terminal.printf("\n\r\t\t\e[1;37m           ESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                INGENIERIA EN COMUNICACIONES Y ELECTRONICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                            ANALISIS NUMERICO\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                        PROGRAMA SECUENCIAS LED-BUZZER\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                      ALUMNO: MARCELO PADRON JAVIER\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                              GRUPO: 4CV2\e[0m\n\n");
    wait(3.0);//Retardo de 3 segundos
    
}
void Seleccion()//Funcion Seleccion
{   
Primero:    
    terminal.printf("\n\n\r\t\e[1;33mEste programa despliega una secuencia de luces, una secuencia\n\r\tde sonido o ambas al mismo tiempo.\e[0m\n");
    terminal.printf("\n\r\t\e[1;34mOprima 1 si: Desea que se despliegue la secuencia de luces.\e[0m\n");
    terminal.printf("\n\r\t\e[1;35mOprima 2 si: Desea que se despliegue una secuencia de sonido.\e[0m\n");
    terminal.printf("\n\r\t\e[1;36mOprima 3 si: Desea que se desplieguen ambas secuencias.\e[0m\n\n\n\n");
    char valor = terminal.getc(); //Seleccion de opcion(No funciona!!)
    wait(2.0);
    valor = '3';//Valor predefinido que lanza la secuencia de Luces y del Buzzer
    switch(valor) { //Menu de opciones
    case '1': terminal.printf("\n\r\t\e[1;34mUsted a seleccionado la opcion 1.\e[0m\n\r"); 
              wait(1.0);   
              terminal.printf("\n\r\t\e[1;34mDesplegando secuencia en\e[0m");
              wait(1.0);
              terminal.printf("\n\r\t\f\e[1;34m3...................\e[0m");
              wait(1.0);
              terminal.printf("\n\r\t\f\e[1;34m2...................\e[0m");
              wait(1.0);
              terminal.printf("\n\r\t\f\e[1;34m1...................\e[0m");
              wait(1.0);
              Barrido.attach_us(&Barrido_OnInterrupt, Ticker_Rate);
              break;
    case '2': terminal.printf("\n\r\t\e[1;35mUsted a seleccionado la opcion 2.\e[0m\n\r"); 
              wait(1.0);   
              terminal.printf("\n\r\t\e[1;35mDesplegando secuencia en....\e[0m");
              wait(1.0);
              terminal.printf("\n\r\t\f\e[1;35m3...................\e[0m");
              wait(1.0);
              terminal.printf("\n\r\t\f\e[1;35m2...................\e[0m");
              wait(1.0);
              terminal.printf("\n\r\t\f\e[1;35m1...................\e[0m");
              wait(1.0);
              for(int x=0; x<40; x++)//Este for solamente repite la secuencia, puedes modificar x.
              {
              int i;
              for (i=0; i<26; i=i+2) { //For que se encarga de aumentar y disminuir frecuencias del Buzzer.
              Buzzer.period(1.0/969.0);
              Buzzer = float(i)/50.0;
              wait(.5);
              Buzzer.period(1.0/800.0);
              wait(.5);
              }
              for (i=25; i>=0; i=i-2) {
              Buzzer.period(1.0/969.0);
              Buzzer = float(i)/50.0;
              wait(.5);
              Buzzer.period(1.0/800.0);
              wait(.5);
              }
              Buzzer = 0.0;
              }
              break;
    case '3': terminal.printf("\n\r\t\e[1;36mUsted a seleccionado la opcion 3.\e[0m\n\r"); 
              wait(1.0);   
              terminal.printf("\n\r\t\e[1;36mDesplegando secuencia en....\e[0m");
              wait(1.0);
              terminal.printf("\n\r\t\f\e[1;36m3...................\e[0m");
              wait(1.0);
              terminal.printf("\n\r\t\f\e[1;36m2...................\e[0m");
              wait(1.0);
              terminal.printf("\n\r\t\f\e[1;36m1...................\e[0m");
              wait(1.0);
              {
              Barrido.attach_us(&Barrido_OnInterrupt, Ticker_Rate);
              for(int x=0; x<40; x++)
              {
              int i;
              for (i=0; i<26; i=i+2) {
              Buzzer.period(1.0/969.0);
              Buzzer = float(i)/50.0;
              wait(.5);
              Buzzer.period(1.0/800.0);
              wait(.5);
              }
              for (i=25; i>=0; i=i-2) {
              Buzzer.period(1.0/969.0);
              Buzzer = float(i)/50.0;
              wait(.5);
              Buzzer.period(1.0/800.0);
              wait(.5);
              }
              Buzzer = 0.0;
              }
              }
              break; 
     default: terminal.printf("\n\r\n\rUsted ha ingresado una opcion que no es valida!!)");
              terminal.printf("\n\rEn unos instantes lo regresaremos al menu!!\n\r");
              wait(4.0);
              goto Primero; // Regresa al usuario a la seleccion de opcion n veces hasta que seleccione una opcion valida 
}
}  
void Barrido_OnInterrupt()
{
    /* Rutina de Atención a la Interrupción */
    contadorA++;                     // Incremeta el contador de mili segundos
    if (contadorA == delayA)          // Contador es igual al retardo programado?
    {
    Torreta=SecuenciaA[A];          // Escribe la secuencia
    A++;                            // Incrementa el índice
    if (A >= No_SecuenciasA) A=0;    // Es la última secuencia?
    contadorA =0;                    // Reinicia contador de retardo
    Led_Monitor = !Led_Monitor;     // Parpadeo del Led Monitor
    }
}
/* END routines */   
 
/* END program */                

/* END documentation */ 
/*

+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/
/* END Mbed */ 