/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_Minimos
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         This module contains user's application code.
**   Componentes     : Timer, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocodades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**          - Marcelo Padron Javier
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 22/10/2019
**                   
**                     
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
#define Ticker_Rate     1000            // Tiempo del Ticker
////////////////////////////////////////// Definimos las notas notas musicales y su frecuencia.
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/ 
DigitalOut   verde  (LED1);    // NC       (Green_Led) 
DigitalOut   Led_Monitor (PB_1);         // Led monitor de la Tarjeta STM32F103C8
Serial       terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial     terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
/*
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Portada();
void Principal();
void Setup(void);  
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{  
              
Setup();            // Inicialización del sistema
Portada();
Principal();
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{
//  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.    
  terminal.baud(115200);              // Se configura la velocidad de transmisión e inicia la comunicación serial.  
}  
void Portada()//Funcion Portada  
{
    terminal.printf("\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0101  0101  0101  0101 0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\r\t\e[1;32m01    01      01    010 010  01        0   0  1  01    0  1   10  01    010  10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m0101  0101    01    01 1 10  0101     1    0101  01    0101   10  0101  01 1 10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m01      01    01    01   10  01      0     0  1  01    0  1   10  01    01  010  01    0  1\e[0m"); 
    terminal.printf("\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0  1  0101  0  1   10  0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\n\r\t\e[1;32m       \'NUESTROS COLORES VERDE \e[0m\e[1;37mY BLANCO, POR QUE EL\e[0m\e[1;31m ROJO LO LLEVAMOS EN LA SANGRE!!!\'\e[0m\n\n");
    terminal.printf("\n\r\t\t\e[1;37m           ESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                INGENIERIA EN COMUNICACIONES Y ELECTRONICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                            ANALISIS NUMERICO\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                             PROGRAMA: MINIMOS\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                      ALUMNO: MARCELO PADRON JAVIER\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                              GRUPO: 4CV2\e[0m\n\n");
    wait(3.0);//Retardo de 3 segundos   
}
void Principal()
{
    {
 float  aux[10],aux1[10],auxx[10],resultado[10],suma,sumat[10],tole[10],
        tole1,tolefin[10],tolerancia,w,x1[10],xy[10][10];
 int    grado,h,i,j;

 terminal.printf("\nCual es el grado de la ecuaci¢n (2 ¢ 3): \n");
 grado=terminal.getc();
 for(j=0;j<10;j++)
 {
  auxx[j]=0;
  }
 for(i=0;i<grado;i++)
 {
  terminal.printf("\nIngresa la Ecuaci¢n Numero %d \n",i+1);
  for(j=0;j<grado;j++)
  {
   terminal.printf("\nX%d%d= ",i+1,j+1);
   xy[i][j]=terminal.getc();
   }
  terminal.printf("\nY%d=  ",i+1);
  resultado[i]=terminal.getc();
  }
 terminal.printf("\nLas ecuaciones que ingresaste son:\n");
 for(i=0;i<grado;i++)
 {
  for(j=0;j<grado;j++)
  {
   terminal.printf(" %.0f[X%d]",xy[i][j],j+1);
   if(j==0)
    printf("+");
   }
  terminal.printf("=",i+1);
  terminal.printf("%.0f",resultado[i]);
  terminal.printf("\n");
  }
 terminal.printf("\n Matriz a resolver:\n");
 for(i=0;i<grado;i++)
 {
  terminal.printf("\n%c ",179);
  for(j=0;j<grado;j++)
  {
   terminal.printf(" %.0f ",xy[i][j],j+1);
   }
  terminal.printf(" %c",179);
  terminal.printf("  %.0f ",resultado[i]);
  terminal.printf(" %c",179);
  }
 terminal.printf("\nIngresa la Exactitud o Tolerancia: ");
 tolerancia=terminal.getc();
 for(;;)
 {
  h=0;
  do
  {
   suma=0;
   for(i=h;i<h+1;i++)
   {
    for(j=0;j<grado;j++)
    {
     if(j!=i)
     {
      suma+=((xy[i][j]*x1[j])/xy[i][i]);
      }

     }
    }
   sumat[h]=suma;
   h++;
   }while(h<grado);
  for(i=0,j=grado-1;i<grado;i++,j--)
  {
   aux[i]=auxx[j];
   }
  for(i=0;i<grado;i++)
  {
   for(j=0;j<grado;j++)
   {
    if(i!=j)
    {
     auxx[i]=((resultado[i])/xy[i][i])-(sumat[i]);
     }
else{
    terminal.printf("INDETEMINA");
}
    }
   }
  for(i=0,j=grado-1;i<grado;i++,j--)    {  x1[i]=auxx[i];  }
  for(i=0;i<grado;i++)          {  tole[i]=0;  }
  for(i=0,j=grado-1;i<grado;i++,j--)    {  aux1[i]=auxx[j];  }
  for(i=0;i<grado;i++)          {  tole[i]=aux1[i]-aux[i];  }

  int k=0;
  while(k<grado)
  {
   for(i=0;i<grado-1;i++)
   {
    if(tole[i]<tole[i+1])
    {
     tole1=tole[i];tole[i]=tole[i+1];tole[i+1]=tole1;
     }
    }
   k++;
   }
  for( j=0;j<grado;j++)
  {
   tolefin[j]=tole[j];
   }
  w=tolefin[0];
  terminal.printf("\n");
  for(j=0;j<grado;j++)
  {
   terminal.printf("x%d=  %f\n",j+1,auxx[j]);
   }
  if(fabs(w)<=tolerancia)
  {
   terminal.printf("\nResultados en la Iteracion Numero %d \n");
   for(j=0;j<grado;j++)
   {
    terminal.printf("X%d=%.15f\n",j+1,auxx[j]);
    }
   terminal.getc();
   break;
   }
  }
 }
    }
/* END routines */   
 
/* END program */                

/* END documentation */ 
/*

+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/
/* END Mbed */ 
