/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-F103C8_Plantilla
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuracion del uso de la terminal serial
**         This module contains user's application code.
**   Componentes     : Serial, etc .
**   Configuraciones : Se puede selecionar entre diferentes  velocidades de transmision
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**          - Marcelo Padron Javier 
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "stm32f103c8t6.h"
#include "PinNames.h"
#include "Serial.h"
#include "stdio.h"
#include "math.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define  on             0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FASLO
#define TRUE            1               // Estado VERDADERO
#define t 100 
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
// Host Pc terminal Comunication channel
Serial terminal (PA_2,PA_3);  //Inicioaliza la comunicacion serial a la PC(RX,TX)   
//Serial terminal(USBTX,USBRX,1115200);/TX,RX
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint32_t Baud_Rate   =  115200 ;           // Velocidad de transmision
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Setup(void); //Function que inicializa la tarjeta;
void Portada();
void pidedatos(); 
void mat_imp(); 
void correjir(); 
void gaussjordan(); 
void imprime();
/*
END definitions */  
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{
Setup();            // Inicialización del sistema
Portada();          //Mandar a llamar a la funcion Portada.
int op; 
do 
{ 
  pidedatos(); 
  mat_imp(); 
  correjir(); 
  gaussjordan(); 
  imprime(); 
  printf("Quieres otro calculo?n1.Sin0.NonR= "); 
  op =terminal.getc(); 
} 
  while(op>=1); 
  terminal.printf("nn"); 
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
  
/*
______________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup() 
{
  terminal.baud(115200);
}
void Portada()//Funcion Portada
{
    terminal.printf("\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0101  0101  0101  0101 0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\r\t\e[1;32m01    01      01    010 010  01        0   0  1  01    0  1   10  01    010  10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m0101  0101    01    01 1 10  0101     1    0101  01    0101   10  0101  01 1 10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m01      01    01    01   10  01      0     0  1  01    0  1   10  01    01  010  01    0  1\e[0m"); 
    terminal.printf("\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0  1  0101  0  1   10  0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\n\r\t\e[1;32m       \'NUESTROS COLORES VERDE \e[0m\e[1;37mY BLANCO, POR QUE EL\e[0m\e[1;31m ROJO LO LLEVAMOS EN LA SANGRE!!!\'\e[0m\n\n");
    terminal.printf("\n\r\t\t\e[1;37m           ESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                INGENIERIA EN COMUNICACIONES Y ELECTRONICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                            ANALISIS NUMERICO\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                            PROGRAMA GAUSS JORDAN\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                      ALUMNO: MARCELO PADRON JAVIER\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                              GRUPO: 4CV2\e[0m\n\n");
    wait(3.0);//Retardo de 3 segundos   
}
int i,j,k,n=0,col,fila,op,op1,op2; 
float a[t][t+1]={0};
void pidedatos() 
 { terminal.printf("Programa para resolver sistemas de ecuaciones de hasta 100 incognitas"); 
   terminal.printf("nCuantas incognitas son?: "); 
   n = terminal.getc(); 
   terminal.printf("n"); 
   for(i=0;i<=n-1;i++) 
   { 
   for(j=0;j<=n;j++) 
     { 
   terminal.printf("A[%d][%d] = ",i,j); 
   a[i][j] = terminal.getc(); 
   } 
   printf("n"); 
   } 
   } 
void gaussjordan() 
{ 
   for(i=0;i<=n-1;i++) 
   { 
   for(j=n;j>=0;j--) 
   { 
   a[i][j]=a[i][j]/a[i][i]; 
   } 
   for(k=i+1;k<=n-1;k++) 
   { 
   for(j=n;j>=0;j--) 
   { 
   a[k][j]=a[k][j]-a[k][i]*a[i][j]; 
   } 
   } 
   for(k=0;k<=i-1;k++) 
   { 
   for(j=n;j>=0;j--) 
   { 
   a[k][j]=a[k][j]-a[k][i]*a[i][j]; 
   }
   } 
   } 
   } 
void mat_imp()
{ 
printf("nSu matriz es: nn"); 
for(i=0;i<=n-1;i++) 
{ 
for(j=0;j<=n;j++) 
{ 
terminal.printf(" %f ",a[i][j]); 
} 
terminal.printf("n"); 
} 
terminal.printf("nn");
} 
void correjir()
{ 
do{ 
terminal.printf("nHay algun error? Si.1tNo.0 "); 
op2 = terminal.getc(); 
if(op2==1) 
{ 
do{ 
terminal.printf("nSeleccione la posicion ----> "); 
terminal.printf(" [i] = "); 
fila = terminal.getc(); 
float i=fila;
terminal.printf("tttt[j] = "); 
col = terminal.getc(); 
float j=col;
terminal.printf("Que valor es? "); 
a[i][j]=teminal.getc(); 
terminal.printf("Tiene otro error? Si.1tNo.0 "); 
op = terminal.getc(); 
}
while(op>=1); 
mat_imp(); 
op1=0; 
} 
else terminal.printf("nOK!"); 
op1=0; 
}
while(op1>=1); 
terminal.printf("nn"); 
} 
void imprime() 
{ 
terminal.printf("Sus resultados son:"); 
for(i=0;i<=n-1;i++) 
{ 
terminal.printf("nX[%d] = %f",i,a[i][n]); 
} 
terminal.printf("nn"); 
} 


/* END routines */    
                
/* END program */

/*+-----------------------------------------------------------------------------       
*+  Conexión al Led Testigo:
*+ 
*+  Los leds se pueden conectar a cualquier pin que se declare como DigitalOut. 
*+  El dispositivo puede drenar hasta 20ma por todas sus salidas a un voltaje de 
*+  3.3V, pero se recomienda no exceder de 1mA por salida.
*+  Esto se logra poniendo una resistencia limitadora de mínimo 330 Ohms.
*+  
*+    3.3V o 5V
*+       O
*+       |
*+       |
*+       /
*+       \   1K
*+       /
*+       \                         UTILIZANDO LÓGICA NEGATIVA
*+       |
*+    __|__
*+    \      /
*+     \    /
*+      \  /
*+     _\/_
*+       |
*+       |__________________________  PIN (Digital Out)
*+
*+      
*+      
*+       
*+                    1K
*+                   
*+        ________/\  /\  /\  ____    PIN (Digital Out)
*+       |           \/  \/  \/
*+       |      
*+       |
*+     __|__
*+    \      /
*+     \    /
*+      \  /                       UTILIZANDO LÓGICA POSITIVA
*+      _\/_
*+       |
*+       |
*+       |
*+     __|__
*+      ___
*+       _
*+       _
*+
*+      GND
*+
+----------------------------------------------------------------------------
*+
*+   Powered by
*+
*+          T H E     A N T U L I U ' S   T E A M   R&D  Unltd 
*+
*+  Research, Development, Systems, Equipment, Support & Spare Parts.
*+  (C) Copyright 1989-2019, All Rights Reserved            
*+
*+  Welcome to The Beaners Proyect Community!                   
*+----------------------------------------------------------------------------*/

/* END Mbed */