/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_Error
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         This module contains user's application code.
**   Componentes     : Timer, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocodades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**          - Marcelo Padron Javier
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 22/10/2019
**                   
**                     
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
#define Ticker_Rate     1000            // Tiempo del Ticker
////////////////////////////////////////// Definimos las notas notas musicales y su frecuencia.
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/ 
DigitalOut   verde  (LED1);    // NC       (Green_Led) 
DigitalOut   Led_Monitor (PB_1);         // Led monitor de la Tarjeta STM32F103C8
Serial       terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial     terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
/*
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Portada();
void Error();
void Setup(void);  
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{  
              
Setup();            // Inicialización del sistema
Portada();
Error();
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{
//  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.    
  terminal.baud(115200);              // Se configura la velocidad de transmisión e inicia la comunicación serial.  
}  
void Portada()//Funcion Portada  
{
    terminal.printf("\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0101  0101  0101  0101 0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\r\t\e[1;32m01    01      01    010 010  01        0   0  1  01    0  1   10  01    010  10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m0101  0101    01    01 1 10  0101     1    0101  01    0101   10  0101  01 1 10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m01      01    01    01   10  01      0     0  1  01    0  1   10  01    01  010  01    0  1\e[0m"); 
    terminal.printf("\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0  1  0101  0  1   10  0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\n\r\t\e[1;32m       \'NUESTROS COLORES VERDE \e[0m\e[1;37mY BLANCO, POR QUE EL\e[0m\e[1;31m ROJO LO LLEVAMOS EN LA SANGRE!!!\'\e[0m\n\n");
    terminal.printf("\n\r\t\t\e[1;37m           ESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                INGENIERIA EN COMUNICACIONES Y ELECTRONICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                            ANALISIS NUMERICO\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                              PROGRAMA: ERROR\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                      ALUMNO: MARCELO PADRON JAVIER\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                              GRUPO: 4CV2\e[0m\n\n");
    wait(3.0);//Retardo de 3 segundos   
}

void error(){
    int n,x,y,a,i,w;
    float error=.1;
    float z;
    i=1;
    terminal.printf("Para este programa es necesario que la matriz "); 
    terminal.printf("\ningresada tenga los coeficientes mas altos\nen la diagonal\n");
    terminal.printf("Ingrese la cantida de variables a encontrar (cantidad de ecuaciones\n");
    n=terminal.getc();

    float A[n][n];
    float B[n];
    float sig[n];
    float ant[n];
    float auxa[n];
    float auxb=0;

        for (x = 0; x < n; x++){ // CREA 0 en aux
            auxa[x]=0;
            sig[x]=0;
        }

    for (x = 0; x < n; x++){ //llena matriz A
            terminal.printf("Ingrese los elementos del renglon "); 
            terminal.printf("%i",x+1); 
            terminal.printf("de la matriz de coeficientes");
        for(y = 0; y < n; y++){
            A[x][y]=terminal.getc();
        }
    }
        terminal.printf("Ingrese la matriz de resultados: ");
    for (x = 0; x < n; x++){ // llena matriz B de resultados
        B[x]=terminal.getc();
    }
    terminal.printf("Ingrese cantidad maxima de iteraciones");
    w=terminal.getc();
    terminal.printf("Ingrese el error de convergencia");
    error=terminal.getc();
    terminal.printf("MATRIZ INGRESADA");
    for (x = 0; x < n; x++){ //MUESTRA LA MATRIZ INGRESADA
        for(y = 0; y < n; y++){
            terminal.printf("%f",A[x][y]);
        }
        terminal.printf("|"); terminal.printf("%f",B[x]);
        }
    for (x = 0; x < n; x++){ //QUITA 0 DE LA DIAGONAL CAMBIANDO RENGLONES
        if (A[x][x] == 0){
            for (y = x; y < n ; y++){
                if (A[y][x] == 0){
                }
                else {
                    for (a = 0; a < n; a++){
                    auxa[a]=A[y][a];
                    A[y][a]=A[x][a];
                    A[x][a]=auxa[a];
                }
                auxb=B[y];
                B[y]=B[x];
                B[x]=auxb;
                }
            }

        }
    }
    ///for ()
    for(x = 0; x<n ; x++){
        z=A[x][x];
        for(y = 0; y<n ; y++){
        A[x][y]=(A[x][y])/(-z);
        }
        A[x][x]=0;
        B[x]=B[x] / z;
        ant[x]=B[x];
    }
    for(a = 0; a<n ; a++){
        for (y = 0; y<n ; y++){
        sig[a]=sig[a]+(ant[y]*A[a][y]);
        }
        sig[a]=sig[a]+B[a];
        }
    for (x = 0; x<n ; x++){
        while (abs(sig[x]-ant[x]) > error && w > i){ //Hace los pasos hasta que el error sea menor a error
            for (y = 0; y<n ;y++){
                ant[y]=sig[y];
            }
        for(a = 0; a<n ; a++){
                sig[a]=0;
                for (y = 0; y<n ; y++){
                sig[a]=sig[a]+(ant[y]*A[a][y]);
            }
            sig[a]=sig[a]+B[a];
        }
        i++;
        }
}
if(i > w ){
    terminal.printf("El error no converge a "); terminal.printf("%f",error); 
    terminal.printf(" en "); terminal.printf("%i",w); terminal.printf(" iteraciones");;
}
else{
terminal.printf(" Se llego a los resultados en "); terminal.printf("%f",i+1); terminal.printf(" iteraciones\n\n");
terminal.printf(" Con un error de "); terminal.printf("%f",error); 
terminal.printf(" Los valores de las variables son: \n\n");
for(x = 0; x<n ; x++){
    terminal.printf("X");terminal.printf("%f",x);terminal.printf(" = ");
    terminal.printf("%f",sig[x]);
}
}
}
/* END routines */   
 
/* END program */                

/* END documentation */ 
/*

+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/
/* END Mbed */ 
