/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_Portada
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         This module contains user's application code.
**   Componentes     : Timer, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocodades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**          - Marcelo Padron Javier
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 22/10/2019
**                   
**                     
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
#define Ticker_Rate     1000            // Tiempo del Ticker
#define RAIZ(x)         ((x)+2)
////////////////////////////////////////// Definimos las notas notas musicales y su frecuencia.
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/ 
DigitalOut   verde  (LED1);    // NC       (Green_Led) 
DigitalOut   Led_Monitor (PB_1);         // Led monitor de la Tarjeta STM32F103C8
Serial       terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial     terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
/*
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Portada();
void Calculos();
void Setup(void);  
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{  
              
Setup();            // Inicialización del sistema
Portada();
Calculos();         //Mandar a llamar a la funcion Calculos.
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{
//  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.    
  terminal.baud(115200);              // Se configura la velocidad de transmisión e inicia la comunicación serial.  
}  
void Portada()//Funcion Portada  
{
    terminal.printf("\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0101  0101  0101  0101 0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\r\t\e[1;32m01    01      01    010 010  01        0   0  1  01    0  1   10  01    010  10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m0101  0101    01    01 1 10  0101     1    0101  01    0101   10  0101  01 1 10  01    0  1\e[0m");
    terminal.printf("\n\r\t\e[1;32m01      01    01    01   10  01      0     0  1  01    0  1   10  01    01  010  01    0  1\e[0m"); 
    terminal.printf("\n\r\t\e[1;32m0101  0101  010101  01   10  0101    0101  0  1  0101  0  1   10  0101  01   10  0101  0101\e[0m");
    terminal.printf("\n\n\r\t\e[1;32m       \'NUESTROS COLORES VERDE \e[0m\e[1;37mY BLANCO, POR QUE EL\e[0m\e[1;31m ROJO LO LLEVAMOS EN LA SANGRE!!!\'\e[0m\n\n");
    terminal.printf("\n\r\t\t\e[1;37m           ESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                INGENIERIA EN COMUNICACIONES Y ELECTRONICA\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                            ANALISIS NUMERICO\e[0m"); 
    terminal.printf("\n\n\r\t\t\e[1;37m                      PROGRAMA: METODO DE BISECCION\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                      ALUMNO: MARCELO PADRON JAVIER\e[0m");
    terminal.printf("\n\n\r\t\t\e[1;37m                              GRUPO: 4CV2\e[0m\n\n");
    wait(3.0);//Retardo de 3 segundos   
}
void Calculos()
{

float xi, xu, xr, xa, ea;
int iteraciones; 
terminal.printf("Limite superior de la raiz: ");
xi=terminal.getc();
terminal.printf("Limite inferior de la raiz: ");
xu=terminal.getc();
terminal.printf("%12s %10s %10s %10s %10s\n", "Iteraciones", "Xi", "Xu", "Xr", "Ea");  
iteraciones=0;
xa = 0.0;
ea = 0;
do{
iteraciones++;
xr = (xi + xu) / 2;
if(iteraciones >= 2) 
{
ea = ((xr - xa) / xr) * 100; // Calculamos el error aproximado a partir de la segunda iteración
}
ea = fabs(ea); // Calculamos el valor absoluto del número
terminal.printf("%12d %10f %10f %10f %10f\n", iteraciones, xi, xu, xr, fabs(ea));
xa = xr;
if(RAIZ(xr) > 0) 
{
xi = xr;
} 
else{
xu = xr;
}
} 
while(ea > 0.5 || (ea == 0.0 && iteraciones == 1));
terminal.printf("\nLa raiz es de f(x) = x + 2; es: \n", xr); 
}
/* END routines */   
 
/* END program */                

/* END documentation */ 
/*

+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/
/* END Mbed */ 