#include "PC.h"

/***** Definitions *****/

//******************************************************************************
PC::PC(PinName _led, PinName tx, PinName rx) : MODSERIAL( tx, rx,  PCTxBufferSize,  PCRxBufferSize, NULL )
{     
    
    led=NULL;
    
    MailNum=0;
    
    if(_led!=NC) led=new DigitalOut(_led);
    baud(PCBaudRateDef);
    format(8,SerialBase::None,1);
    autoDetectChar('\n');   
    this->attach(this,&PC::messageFrom, MODSERIAL::RxAutoDetect); 
}

PC::PC(PinName _led, PinName tx, PinName rx, void (*iEventHandler)(int, char *)) : MODSERIAL( tx, rx,  PCTxBufferSize,  PCRxBufferSize, NULL )
{
    
    iEvent=iEventHandler;
    led=NULL;
    
    MailNum=0;
    
    
    if(_led!=NC) led=new DigitalOut(_led);
    baud(PCBaudRateDef);
    format(8,SerialBase::None,1);
    autoDetectChar('\n');   
    this->attach(this,&PC::messageFrom, MODSERIAL::RxAutoDetect); 
}

void PC::start(void)
{
    thread.start(this,&PC::Paralell_thread); 
}

//******************************************************************************
PC::~PC()
{   
}

//******************************************************************************

void PC::messageFrom(MODSERIAL_IRQ_INFO *q) {
    MODSERIAL *sys = q->serial;
    int i=sys->move(messageBufferIncoming, PCTxBufferSize);
    messageBufferIncoming[i]='\n';
    messageBufferIncoming[i+1]=0;
    LoadMail(0,messageBufferIncoming);
    
    if(led!=NULL)
    {
        led->write(true);
        wait_us(250);
        led->write(false);
    }
    //sys->rxBufferFlush();
}

void PC::Paralell_thread() 
{
    while(true) 
    {
        char mess[PCTxBufferSize];
        char Tstr[20];
        osEvent evt = mails.get(osWaitForever);
        if (evt.status == osEventMail) 
        {
            mail_t *mail = (mail_t*)evt.value.p;
            switch (mail->command) 
            {
                case 0: //request from PC
                    switch (mail->message[0]) 
                    {
                        
                        
                        case '@': //command to PC
                            switch(mail->message[1])
                            {
                                case 'R'://Reboot
                                    mbed_reset();//wd.Configure(2.0);
                                    break;
                                case 'r'://Reboot
                                    mbed_reset();//wd.Configure(2.0);
                                    break;
                                default:
                                    break;
                            }
                            break;
                        case '#': //command Pulses
                            switch(mail->message[1])
                            {
                                case 'S'://State
                                    if(iEvent!=NULL) iEvent(eState,&mail->message[2]);
                                    break;
                                case 'P'://Pulse
                                    if(iEvent!=NULL) iEvent(ePulse,&mail->message[2]);
                                    break;
                                case 'M'://Pulse
                                    if(iEvent!=NULL) iEvent(ePulsems,&mail->message[2]);
                                    break;
                                case 's'://Pulse
                                    if(iEvent!=NULL) iEvent(ePulses,&mail->message[2]);
                                    break;
                                default:
                                    break;
                            }
                            break;
                        default: //
                            break;
                    }
                    break;
                case 1: //Send LOG to PC
                    TLogSTR(Tstr);
                    snprintf(mess,PCTxBufferSize,"LOG(%s):%s",Tstr ,mail->message);
                    Com_Write(mess);
                    break;
                case 2: //Send to PC
                    Com_Write(mail->message);
                    break;
                default:
                    break;
            }
            mails.free(mail);
            MailNum--;
        }
    }
}

void PC::TLogSTR(char *Tstr)
{
    time_t ctTime;
    struct tm * timeinfo;

    ctTime = time(NULL);
    timeinfo = localtime ( &ctTime );
    //timeinfo->tm_hour=(timeinfo->tm_hour+1)%24;
    strftime (Tstr,PCTxBufferSize,"%H:%M:%S",timeinfo);
}

void PC::LoadMail(char comm,  char *mess) //para cargar mensajes de trabajo al proceso paralelo ComPC_thread_proc
{
    if(comm!=1)
    {
        while(MailNum>=PCMaxMailElements) wait_us(PCWaitMess_us);
        mail_t *pmail = mails.alloc();
        pmail->command = comm;
        snprintf(pmail->message,PCTxBufferSize,"%s",mess);
        mails.put(pmail);
        MailNum++;
    }
}

int PC::Com_Write(char *mess) //sólo para usarse en ComPC_thread_proc
{
    int i=strlen(mess);
    if(i>0) {
        while((PCTxBufferSize-this->txBufferGetCount())<i) wait_us(PCWaitByte_us);
        return this->printf(mess);
    }
    return 0;
}
