#ifndef _PC_H_
#define _PC_H_

#include "mbed.h"
#include "rtos.h"
#include "MODSERIAL.h"

#define PCTxBufferSize 200
#define PCRxBufferSize 200
#define PCMaxMailElements 8
#define PCBaudRateDef 115200
#define PCWaitByte_us (10000000/PCBaudRateDef)
#define PCWaitMess_us PCWaitByte_us*10

#define Rate 1
    
extern "C" void mbed_reset();

class PC : public MODSERIAL
{

public:


    PC(PinName _led, PinName tx, PinName rx);
    PC(PinName _led, PinName tx, PinName rx, void (*iEventHandler)(int, char *));
    void AttachSendStatus(void);
    void DetachSendStatus(void);
    ~PC();    
    
    void LoadMail(char comm,  char *mess); //para cargar mensajes de trabajo al proceso paralelo ComPC_thread_proc
    
    void start(void);
    enum MyEventsPC {eLOG=100, eState, ePulse, ePulsems, ePulses};
    
private:

    DigitalOut *led;
    char messageBufferIncoming[PCRxBufferSize];
    char messageBufferOutgoing[PCTxBufferSize];
    
    Thread thread;
    
    void (*iEvent)(int, char *);
    
    typedef struct {
        char command;   /* command to execute */
        char message[PCTxBufferSize];   /* arguments */
    } mail_t;
    
    void TLogSTR(char *Tstr);
    Mail<mail_t, PCMaxMailElements> mails;
    int MailNum;
    
    int Com_Write(char *mess); //sólo para usarse en ComPC_thread_proc
    void messageFrom(MODSERIAL_IRQ_INFO *q);
    void Paralell_thread();
    
};        

#endif /* _PC_H_ */
