#include "main.h"

int main()
{ 
    pc.start();   
    
    if (wd.WatchdogCausedReset())
        pc.LoadMail(2,"Watchdog caused reset\r");
        
    pc.LoadMail(2,"starting...\r");
    wait_ms(100);
    
    Setup();   
    //set_time(0);  
    
    while(true) {
        wd.Service();
        wait_ms(10000);
    }
}



void GetConfig()
{
    #define CfgNumParam 3
    #define CfgSizeParam 50
    
    /*ConfigFile cfg;

    int i;
    char Value[CfgNumParam][CfgSizeParam];
    char CfgK[CfgNumParam][CfgSizeParam]= {"InitialMessage","LOGPC"};
*/
    pc.LoadMail(2,"\r* * *\r* * *\r");
    wait_ms(100);

  /*  if (!cfg.read("/local/config.cfg")) {
        error("\rFailure to read a configuration file");
    }

    pc.LoadMail(2,"aqui\r");
    wait_ms(1000);
    
    char Tstr[10];
    for (i=0; i<CfgNumParam; i++) {
        if (cfg.getValue(CfgK[i], &Value[i][0], sizeof(Value[i]))) {
            //pc.TLogSTR(Tstr);
            pc.printf("CFG_Param(%s): '%s'='%s'\r", Tstr,CfgK[i], Value[i]);
            wait_ms(1000);
        } else {
            error("Failure Reading '%s'\r", CfgK[i]);
        }
    }
    */
    strcpy(InitialMessage,"MBED Ready");//Value[0]);
    pc.LOG=false;//(bool)atoi(Value[1]);

    pc.LoadMail(2,"* * *\r* * *\r");
}


void Setup()
{        
    GetConfig();

    pc.LoadMail(2,"\r");
    pc.LoadMail(2,"\r");
    pc.LoadMail(2,"\r");
    pc.LoadMail(2,"************************************************");
    pc.LoadMail(2,InitialMessage);
    pc.LoadMail(2,"************************************************");
    pc.LoadMail(2,"\r");
    pc.LoadMail(2,"\r");
    pc.LoadMail(2,"\r");

    // ************ WD *************
    wd.WatchdogCausedReset();
    wd.Configure(20.0);
    // ************ WD_end *********    
    
    DigitalOut(LED1,0);
    DigitalOut(LED2,0);
    DigitalOut(LED3,0);
    DigitalOut(LED4,0);
 }
 
 
void PCEventHandler(int e, char *data)
{
    switch(e)
    {
        case PC::eLOG:
            pc.LoadMail(1,data);
            break;
        default:
            break;        
    }
}
