#ifndef _PC_H_
#define _PC_H_

#include "mbed.h"
#include "MODSERIAL.h"
#include "GV.h"

#define PCTxBufferSize 250
#define PCRxBufferSize 250
#define PCMaxMailElements 10
#define PCBaudRateDef 115200
#define PCWaitByte_us (10000000/PCBaudRateDef)
#define PCWaitMess_us PCWaitByte_us*10

#define Rate 1
    
extern "C" void mbed_reset();

class PC : public MODSERIAL
{

public:


    PC(GV * _pac, PinName _led, PinName tx, PinName rx);
    PC(GV * _pac, PinName _led, PinName tx, PinName rx, void (*iEventHandler)(int, char *));
    ~PC();    
    
    void LoadMail(char comm,  char *mess); //para cargar mensajes de trabajo al proceso paralelo ComPC_thread_proc
    
    void start(void);
    
    bool LOG;
    bool SendStatus;
    int mode;
    
    enum MyEventsLCD {eLOG};
    
private:

    GV *pgv;
    
    void (*iEvent)(int, char *);
    
    DigitalOut *led;
    char messageBufferIncoming[PCRxBufferSize];
    char messageBufferOutgoing[PCTxBufferSize];
    
    Thread thread;
    
    typedef struct {
        char command;   /* command to execute */
        char message[PCTxBufferSize];   /* arguments */
    } mail_t;
    
    Mail<mail_t, PCMaxMailElements> mails;
    int MailNum;
    
    void TLogSTR(char *Tstr);
    int Com_Write(char *mess); //sólo para usarse en ComPC_thread_proc
    void messageFrom(MODSERIAL_IRQ_INFO *q);
    void Paralell_thread();
    
    Ticker TStatusToPC;
    void StatusToPC(void);
};        

#endif /* _PC_H_ */



