#include "PC.h"

/***** Definitions *****/

//******************************************************************************
PC::PC(GV *_pgv, PinName _led, PinName tx, PinName rx) : MODSERIAL( tx, rx,  PCTxBufferSize,  PCRxBufferSize, NULL )
{     
    pgv=_pgv;
    iEvent=NULL;
    led=NULL;
    
    MailNum=0;
    LOG=false;
    SendStatus=false;
    mode=0;
    
    if(_led!=NC) led=new DigitalOut(_led);
    baud(PCBaudRateDef);
    format(8,SerialBase::None,1);
    autoDetectChar('\r');   
    this->attach(this,&PC::messageFrom, MODSERIAL::RxAutoDetect); 
}

void PC::start(void)
{
    thread.start(this,&PC::Paralell_thread); 
}

PC::PC(GV *_pgv, PinName _led, PinName tx, PinName rx, void (*iEventHandler)(int, char *)) : MODSERIAL( tx, rx,  PCTxBufferSize,  PCRxBufferSize, NULL )
{
    pgv=_pgv;
    iEvent=iEventHandler;
    led=NULL;
    
    MailNum=0;
    LOG=false;
    SendStatus=false;
    mode=0;
    
    if(_led!=NC) led=new DigitalOut(_led);
    baud(PCBaudRateDef);
    format(8,SerialBase::None,1);
    autoDetectChar('\r');   
    this->attach(this,&PC::messageFrom, MODSERIAL::RxAutoDetect); 
}

//******************************************************************************
PC::~PC()
{   
}

//******************************************************************************

void PC::messageFrom(MODSERIAL_IRQ_INFO *q) {
    MODSERIAL *sys = q->serial;
    int i=sys->move(messageBufferIncoming, PCTxBufferSize);
    messageBufferIncoming[i]='\r';
    messageBufferIncoming[i+1]=0;
    LoadMail(0,messageBufferIncoming);
    
    if(led!=NULL)
    {
        led->write(true);
        wait_us(250);
        led->write(false);
    }
    //sys->rxBufferFlush();
}

void PC::StatusToPC(void)
{
    if(SendStatus)
    {
        char tempMessPC[PCTxBufferSize];
        sprintf(tempMessPC,"%.1f\r",pgv->Variable1);          
        LoadMail(2,tempMessPC);        
    }
}

void PC::Paralell_thread() 
{
    while(true) 
    {
        char mess[PCTxBufferSize];
        char Tstr[20];
        osEvent evt = mails.get(osWaitForever);
        if (evt.status == osEventMail) 
        {
            mail_t *mail = (mail_t*)evt.value.p;
            switch (mail->command) 
            {
                case 0: //request from PC
                    switch (mail->message[0]) 
                    {
                        case '@': //command to PC
                            switch(mail->message[1])
                            {
                                case 'L':
                                    LOG=mail->message[2]=='1';
                                    break;
                                case 'S':
                                    SendStatus=mail->message[2]=='1';
                                    if(SendStatus) TStatusToPC.attach(this,&PC::StatusToPC, Rate);
                                    else TStatusToPC.detach();
                                    break;
                                case 'M':
                                    char temp[20];
                                    temp[0]=mail->message[2];
                                    temp[1]=0;
                                    mode=atoi(temp);
                                    break;
                                case 'R'://Reboot
                                    mbed_reset();//wd.Configure(2.0);
                                    break;
                                case 'r'://Reboot
                                    mbed_reset();//wd.Configure(2.0);
                                    break;
                                case 'H':
                                    time_t rawtime;
                                    struct tm * timeinfo;
                                    int year, month, day, hour, minute, second;
                                    sscanf(&mail->message[2],"%02d%02d%02d%02d%02d%04d",&hour,&minute,&second,&day,&month,&year);
                                    /* get current timeinfo and modify it to the user's choice */
                                    time ( &rawtime );
                                    timeinfo = localtime ( &rawtime );
                                    timeinfo->tm_year = year-1900;
                                    timeinfo->tm_mon = month - 1;
                                    timeinfo->tm_mday = day;
                                    timeinfo->tm_hour = hour;
                                    timeinfo->tm_min = minute;
                                    timeinfo->tm_sec = second;
                                    /* call mktime: timeinfo->tm_wday will be set */
                                    rawtime=mktime (timeinfo);
                                    set_time(rawtime);                         
                                    break;
                                default:
                                    break;
                            }
                            break;
                        default: //
                            switch (mode)
                            {
                                default:
                                    mode=0;
                                    break;
                            }
                            break;
                    }
                    break;
                case 1: //Send LOG to PC
                    TLogSTR(Tstr);
                    snprintf(mess,PCTxBufferSize,"LOG(%s):%s",Tstr ,mail->message);
                    Com_Write(mess);
                    break;
                case 2: //Send to PC
                    Com_Write(mail->message);
                    break;
                default:
                    break;
            }
            mails.free(mail);
            MailNum--;
        }
    }
}

void PC::TLogSTR(char *Tstr)
{
    time_t ctTime;
    struct tm * timeinfo;

    ctTime = time(NULL);
    timeinfo = localtime ( &ctTime );
    strftime (Tstr,PCTxBufferSize,"%H:%M:%S",timeinfo);
}

void PC::LoadMail(char comm,  char *mess) //para cargar mensajes de trabajo al proceso paralelo ComPC_thread_proc
{
    if(comm!=1 || LOG)
    {
        while(MailNum>=PCMaxMailElements) wait_us(PCWaitMess_us);
        mail_t *pmail = mails.alloc();
        pmail->command = comm;
        snprintf(pmail->message,PCTxBufferSize,"%s",mess);
        mails.put(pmail);
        MailNum++;
    }
 }

int PC::Com_Write(char *mess) //sólo para usarse en ComPC_thread_proc
{
    int i=strlen(mess);
    if(i>0) {
        while((PCTxBufferSize-this->txBufferGetCount())<i) wait_us(PCWaitByte_us);
        return this->printf(mess);
    }
    return 0;
}
