#include "mbed.h"

DigitalOut green(p22);
DigitalOut red(p21);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

#define      CH7 0x00000001
#define KEY_HASH 0x00000002
#define      CH6 0x00000004
#define      CH5 0x00000008
#define      CH4 0x00000010
#define      CH3 0x00000020
#define      CH2 0x00000040
#define      CH1 0x00000080
#define     TAPE 0x00000100
#define   B_CAST 0x00000200
#define     CONN 0x00000400
#define      T_T 0x00000800
#define      MON 0x00001000
#define      SEL 0x00002000
#define       LS 0x00004000
#define      TEL 0x00008000
#define    KEY_5 0x00010000
#define    KEY_4 0x00020000
#define    KEY_3 0x00040000
#define    KEY_2 0x00080000
#define    KEY_1 0x00100000
#define      BRB 0x00200000
#define     FUNC 0x00400000
#define    CTCSS 0x00800000
#define    KEY_6 0x01000000
#define    KEY_0 0x02000000
#define KEY_STAR 0x04000000
#define    KEY_9 0x08000000
#define    KEY_8 0x10000000
#define    KEY_7 0x20000000


DigitalOut buttonspl(p20);
DigitalOut ledclock(p19);
DigitalOut leddata(p18);
DigitalOut ledstrobe(p17);
DigitalIn  buttonsdata(p16);

void blues(int ledc)
{
        led1 = led2 = led3 = led4 = 0;
        switch (ledc) {
            case 0:
                led1 = 1;
                break;
            case 1:
                led2 = 1;
                break;
            case 2:
                led3 = 1;
                break;
            case 3:
                led4 = 1;
                break;
            case 4:
                led3 = 1;
                break;
            case 5:
                led2 = 1;
                break;
        }
}

void switchled(int led) {
    int i;
    
    for (i = 0; i < 32 ; i++) {
        ledclock = 0;
        if (i == led)
            leddata = 0;
        else
            leddata = 1;
        ledclock = 1;
    }
}

void button_test(uint32_t buttons) {
        printf("keys down: ");
        if (buttons & CH7)      printf("CH7 ");
        if (buttons & KEY_HASH)         printf("KEY_HASH ");
        if (buttons & CH6)      printf("CH6 ");
        if (buttons & CH5)      printf("CH5 ");
        if (buttons & CH4)      printf("CH4 ");
        if (buttons & CH3)      printf("CH3 ");
        if (buttons & CH2)      printf("CH2 ");
        if (buttons & CH1)      printf("CH1 ");
        if (buttons & TAPE)     printf("TAPE ");
        if (buttons & B_CAST)   printf("B_CAST ");
        if (buttons & CONN)     printf("CONN ");
        if (buttons & T_T)      printf("T_T ");
        if (buttons & MON)      printf("MON ");
        if (buttons & SEL)      printf("SEL ");
        if (buttons & LS)       printf("LS ");
        if (buttons & TEL)      printf("TEL ");
        if (buttons & KEY_5)    printf("KEY_5 ");
        if (buttons & KEY_4)    printf("KEY_4 ");
        if (buttons & KEY_3)    printf("KEY_3 ");
        if (buttons & KEY_2)    printf("KEY_2 ");
        if (buttons & KEY_1)    printf("KEY_1 ");
        if (buttons & BRB)      printf("BRB ");
        if (buttons & FUNC)     printf("FUNC ");
        if (buttons & CTCSS)    printf("CTCSS ");
        if (buttons & KEY_6)    printf("KEY_6 ");
        if (buttons & KEY_0)    printf("KEY_0 ");
        if (buttons & KEY_STAR)         printf("KEY_STAR ");
        if (buttons & KEY_9)    printf("KEY_9 ");
        if (buttons & KEY_8)    printf("KEY_8 ");
        if (buttons & KEY_7)    printf("KEY_7 ");
        printf("\r\n");
}

int boardstatus(uint32_t leds)
{
    uint32_t buttons = 0;
    int i, bbit;
    
    buttonspl = 1;
    wait_us(20);
    buttonspl = 0;
    
    ledstrobe = 1;
    
    for (i = 0; i < 32 ; i++) {
        ledclock = 1;
        if (leds & (1 << i))
            leddata = 0;
        else
            leddata = 1;
        ledclock = 0;
        bbit = buttonsdata;
        buttons |= bbit << i;
    }

    ledstrobe = 0;

    return buttons;
}

int main() {
    green = 1; red = 0;
    int count = 0;
    int buttons, obuttons;
    uint32_t bleds;
    
    ledclock = 0;
    bleds = 0;
    
    buttons = obuttons = 0;

    printf("Hello\r\n");
    
    while(1) {
        if ((count % 10) == 0)
            green = !green;

        if ((count % 5) == 0)
            red = !red;

        buttons = boardstatus(bleds);

        if (buttons != obuttons) {
            button_test(buttons);

#define ISPRESSED(x) (buttons & x)
#define WASPRESSED(x) (!(buttons &x ) && (obuttons & x))

            if (ISPRESSED(CH1)) {bleds |= 0xf;}
            if (ISPRESSED(CH2)) {bleds |= 0xf0;}
            if (ISPRESSED(CH3)) {bleds |= 0xf00;}
            if (ISPRESSED(CH4)) {bleds |= 0xf000;}
            if (ISPRESSED(CH5)) {bleds |= (uint32_t)0xf << 28;}
            if (ISPRESSED(CH6)) {bleds |= (uint32_t)0xf << 24;}
            if (ISPRESSED(CH7)) {bleds |= 0xf << 20;}

            if (WASPRESSED(CH1)) {bleds &= ~0xf;}
            if (WASPRESSED(CH2)) {bleds &= ~0xf0;}
            if (WASPRESSED(CH3)) {bleds &= ~0xf00;}
            if (WASPRESSED(CH4)) {bleds &= ~0xf000;}
            if (WASPRESSED(CH5)) {bleds &= ~((uint32_t)0xf << 28);}
            if (WASPRESSED(CH6)) {bleds &= ~((uint32_t)0xf << 24);}
            if (WASPRESSED(CH7)) {bleds &= ~(0xf << 20);}

            if (ISPRESSED(BRB)) {bleds = 0;}
            obuttons = buttons;
        }
        
        if (count & 1) {
            bleds |= 1 << 16;
            bleds &= ~(1 << 17);
        } else {
            bleds |= 1 << 17;
            bleds &= ~(1 << 16);
        }
        
        count++;
        wait(0.1);
    }
}
