#ifndef GameEngine_H
#define GameEngine_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Jet.h"
#include "Ammo.h"
#include "Monster.h"
#include "Bitmap.h"

class GameEngine
{
public:

    /** Constructor
    *
    */
    GameEngine();
    
    /** Destructor
    *
    */
    ~GameEngine();
    
    /** Initialise the game parameters
    *
    *   This function initialises the game parameter
    */
    void init();
    
    /** Read the inputs
    *
    *   This function reads the inputs from the pad
    */
    void read_input(Gamepad &pad);
    
    /** Update the game parameters
    *
    *   This function updates the game parameters
    */
    void update(Gamepad &pad);
    
    /** Draw the elements in the buffer
    *
    *   This function draws all elements in the buffer
    */
    void draw(N5110 &lcd);
    
    /** Get the value of life */
    int get_life(); 
    
    /** Get the value of the remained monsters */
    int get_monster_number();
    
private:

    /** Check the fire button
    *
    *   This function checks if the fire button is pressed
    */
    void check_fire(Gamepad &pad);
    
    /** Check the collision between the jet and the monster
    *
    *   This function checks if the jet and the monster collide
    */
    void check_Jet_collision(Gamepad &pad);
    
    /** Check the collision between the bullet and the monster
    *
    *   This function checks if the bullet hits the monster
    */
    void check_hit_monster(Gamepad &pad);
    
    /** Check if the monster hits the wall
    *
    *   This function checks if the monster hits the wall
    */
    void check_hit_wall(Gamepad &pad);
    
    
    Jet _Jet;                   // Jet class
    Ammo _Ammo;                 // Ammo class
    Monster _Monster;           // Monster class
    
    char life_buffer[14];       // buffer for life
    char number_buffer[14];     // buffer for monster number
    
    int life;                   // chance to live
    int monster_number;         // number of the monster remained

    Direction _d;               // move direction of the joystick
    float _mag;                 // move magnitude of the joystick
    int _A;                     // button A check

};

#endif