#include "GameEngine.h"
//funtion to construct
GameEngine::GameEngine()
{

}

//function to destruct
GameEngine::~GameEngine()
{
    
}

//function to initialise the game parameters
void GameEngine::init()
{
    monster_number = 50;                // monster number is set to 50
    life = 5;                           // 3 chances to miss the monster 
    _A = 0;                             // A button check 
    
    _Jet.init();                        // initialise the jet
    _Monster.init();                    // initialise the monster
}

//function to read inputs
void GameEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();           // get the move direction of the joystick
    _mag = pad.get_mag();               // get the move magnitude of the joystick
    check_fire(pad);                    // check if the fire button is pressed
}

//function to draw all elements
void GameEngine::draw(N5110 &lcd)
{
    // the bitmap of the cloud
    static int cloud[] = 
    {    
        0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,
        0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
        0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,
        0,1,0,0,0,0,0,0,0,1,0,1,1,0,0,
        1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,
        1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
        0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,
        0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,
        0,0,0,1,1,0,0,1,0,1,0,0,1,0,0,
        0,0,0,0,0,1,1,0,0,0,1,1,0,0,0, 
    };
    lcd.clear();
    Bitmap sprite(cloud, 10, 15);                   // rows & columns of the cloud
    sprite.render(lcd, 60, 5);                      // draw clouds
    sprite.render(lcd, 10, 32);
    _Jet.draw(lcd);                                 // draw jet
    _Monster.draw(lcd);                             // draw monster
    if(_A == 1)                                     // if fire button is  pressed
    {
        _Ammo.draw(lcd);                            // draw bullet
    }
    sprite.render(lcd, 35, 19);
    
    sprintf(life_buffer,"x%d",life);
    lcd.printString(life_buffer,1,0);               // draw life value
    sprintf(number_buffer,"%d",monster_number);
    lcd.printString(number_buffer,25,0);            // draw monster number
    lcd.refresh();
}

//function to update game parameters
void GameEngine::update(Gamepad &pad)
{
    _Jet.update(_d,_mag);                           // update jet position
    _Ammo.update();                                 // update ammo position
    _Monster.update();                              // update monster position
    check_hit_monster(pad);                         // check if the monster is killed
    check_Jet_collision(pad);                       // check if the jet crashed
    check_hit_wall(pad);                            // check if the monster hits the wall
}

//function to check the fire button
void GameEngine::check_fire(Gamepad &pad)
{
    // intialise the bullet if the fire button if pressed
    // the coordinates of the bullet is according to the coordinates of the jet
    if (pad.check_event(Gamepad::A_PRESSED) == true)
        {
          pad.tone(1000.0,0.1);
          Vector2D Jet_pos = _Jet.get_pos();
          //printf("x=%f,y=%f\n", Jet_pos.x, Jet_pos.y);     
          _Ammo.init(Jet_pos.x+7, Jet_pos.y+5);
          _A = 1;
        }  
}

//function to check if the jet crashs
void GameEngine::check_Jet_collision(Gamepad &pad)
{
    Vector2D Jet_pos = _Jet.get_pos();
    Vector2D Monster_pos = _Monster.get_pos();
    //printf("Jet_x=%f,Jet_y=%f\n",Jet_pos.x,Jet_pos.y);
    //printf("M_x=%f,M_y=%f\n",Monster_pos.x, Monster_pos.y);
    
    // reset jet when the monster hits the jet
    if(
    (Jet_pos.x+13 > Monster_pos.x)&&    // right
    (Jet_pos.x < Monster_pos.x+10)&&    // left
    (Jet_pos.y+12 > Monster_pos.y)&&    // top
    (Jet_pos.y < Monster_pos.y+10))     // bottom
    {
        life -= 1;
        pad.tone(1500.0,0.2);
        _Jet.init();
        _Monster.init();
    }    
}

//function to check if the monster is killed
void GameEngine::check_hit_monster(Gamepad &pad)
{
    Vector2D Ammo_pos = _Ammo.get_pos();
    Vector2D Monster_pos = _Monster.get_pos();
    
    // monster diappears if the bullet hits the monster
    // set new monster
    if(
    (Ammo_pos.x+1 > Monster_pos.x)&&
    (Ammo_pos.y+1 >= Monster_pos.y)&&
    (Ammo_pos.y+1< Monster_pos.y+10)&&
    (_A ==1))
    {
        pad.tone(100.0,0.2);
        _A = 0; //Ammo disappears after hit the monster
        monster_number -= 1;
        _Monster.init();
        _Jet.~Jet(); 
    }
    // monster reaches the left edge of the screen
    // can miss 3 monsters maximum
    else if (Monster_pos.x+9 <= 1)
    {
        life -= 1;
        pad.tone(300.0,0.2);
        _Monster.init();
    }
}

//function to check if the monster hits the wall
void GameEngine::check_hit_wall(Gamepad &pad)
{
    Vector2D Monster_pos = _Monster.get_pos();
    Vector2D Monster_velocity = _Monster.get_velocity();
    
    // the monster bounces back when it hits the wall
    if(Monster_pos.y <= 0)
    {   
        Monster_pos.y = 0;                          // top
        Monster_velocity.y = -Monster_velocity.y;
        pad.tone(500.0,0.2);
    }
    else if(Monster_pos.y >= HEIGHT - 8)
    {
        Monster_pos.y = HEIGHT - 8;                 // bottom
        Monster_velocity.y = -Monster_velocity.y;
        pad.tone(500.0,0.2);
    }
    _Monster.set_velocity(Monster_velocity);        // set velocity
    _Monster.set_pos(Monster_pos);                  //monster stays on the screen
}

//function to get the value of life
int GameEngine::get_life()
{
    return life;   
}

//function to get the monster number
int GameEngine::get_monster_number()
{
    return monster_number;    
}