#include "mbed.h"
#include "Hexi_OLED_SSD1351.h"
#include "Ticker.h"
#include "Hexi_KW40Z.h"
#include "HTU21D.h"
#include "string.h"
#include "MAX30101.h"

#define LED_ON      0
#define LED_OFF     1

void StartHaptic(void);
void StopHaptic(void const *n);
void ButtonUp(void);
void ButtonDown(void);
void ButtonRight(void);
void ButtonLeft(void);
void ButtonSlide(void);
void attime(void);

DigitalOut redLed(LED1);
DigitalOut greenLed(LED2);
DigitalOut blueLed(LED3);
DigitalOut haptic(PTB9);

MAX30101 heart(PTB1, PTB0);

/* Instantiate the SSD1351 OLED Driver */ 
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); /* (MOSI,SCLK,POWER,CS,RST,DC) */

/* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */ 
KW40Z kw40z_device(PTE24, PTE25);

/* Define timer for haptic feedback */
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

/* Instantiate the HTU21D Sensor */
HTU21D temphumid(PTB1,PTB0);
DigitalOut powerEN (PTB12); // Power Enable HTU21D Sensor

int sample_ftemp;   //values for the humidity/temp sensors   
int sample_ctemp;
int sample_ktemp;
int sample_humid;
int sample_HR;

char text[20];
int flag=0;
int counter=0;
Ticker timer;  
  
int main() 
{
    powerEN =0;
    
    /* Register callbacks to application functions */
    kw40z_device.attach_buttonUp(&ButtonUp);
    kw40z_device.attach_buttonDown(&ButtonDown);
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    kw40z_device.attach_buttonSlide(&ButtonSlide);

    heart.enable();
        
    /* Get OLED Class Default Text Properties */
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);    

    /* Turn on the backlight of the OLED Display */
    oled.DimScreenON();
    
    /* Fills the screen with solid black */         
    oled.FillScreen(COLOR_BLACK);

    /* Display Text at (x=7,y=0) */
    strcpy((char *) text,"Welcome");
    oled.Label((uint8_t *)text,7,0);

    /* Display text at (x=5,y=40) */ 
    strcpy(text,"Initializing..");
    oled.Label((uint8_t *)text,5,40);
    /*
    Thread::wait(3000);
    
    oled.FillScreen(COLOR_BLACK);
    
    strcpy((char *) text,"Functions List:");
    oled.Label((uint8_t *)text,7,0);
    
    textProperties.fontColor   = COLOR_BLUE;
    oled.SetTextProperties(&textProperties);
    
    
    strcpy((char *) text,"Left:Bike Menu");
    oled.Label((uint8_t *)text,0,15);
    
    
    strcpy((char *) text,"Right:Biometrics");
    oled.Label((uint8_t *)text,0,35);
    */
    Thread::wait(3000);
    
    
    oled.FillScreen(COLOR_BLACK);
    
    textProperties.fontColor = COLOR_RED;
    oled.SetTextProperties(&textProperties);   
    
    
    strcpy((char *) text,"Temp:");
    oled.Label((uint8_t *)text,5,15);
    
    //display Humidity-linked to while loop
    strcpy((char *) text,"Humidity:");
    oled.Label((uint8_t *)text,5,30);
    
    //display timer-linked to while loop for continuous readings
    strcpy((char *) text,"Timer:");
    oled.Label((uint8_t *)text,5,45);
    
    //display Humidity-linked to while loop
   // strcpy((char *) text,"HR:");
   // oled.Label((uint8_t *)text,5,60);
    
    
      
        
    while(true)
    {
        sample_ftemp = temphumid.sample_ftemp();
        sample_humid = temphumid.sample_humid();
        sample_ftemp-=10;
       // sample_HR = heart.getRevisionID();
        
        textProperties.fontColor = COLOR_WHITE;
        textProperties.alignParam = OLED_TEXT_ALIGN_RIGHT;
        oled.SetTextProperties(&textProperties);
        
        /* Format the value */
        sprintf(text,"%d F",sample_ftemp);
        /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
        oled.TextBox((uint8_t *)text,55,15,35,15); //Increase textbox for more digits
        
        /* Format the value */
        sprintf(text,"%d %%",sample_humid);
        /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
        oled.TextBox((uint8_t *)text,55,30,35,15); //Increase textbox for more digits
        
        sprintf(text,"%d s",counter); 
        // Display time reading in 35px by 15px textbox at(x=55, y=40)
        oled.TextBox((uint8_t *)text,55,45,35,15); //Increase textbox for more digits  
        
       // sprintf(text,"%d bpm",sample_HR); 
        // Display time reading in 35px by 15px textbox at(x=55, y=40)
        //oled.TextBox((uint8_t *)text,55,60,35,15); //Increase textbox for more digits  
        //Thread::wait(300);     
    }
}
void attime(void)
{
    counter++;    
}
void ButtonUp(void)
{
    StartHaptic();
    Thread::wait(50); 
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;
    
    
    if(flag==0)
    {
        timer.attach(&attime,1);
        flag=1;
    }
    else
    {
        timer.detach();
        counter=0;
        flag=0;
    }
}

void ButtonDown(void)
{
    StartHaptic();
    Thread::wait(50); 
    StartHaptic();
    
    redLed      = LED_OFF;
    greenLed    = LED_ON;
    blueLed     = LED_OFF;
    
    if(flag==0)
    {
        timer.attach(&attime,1);
        flag=1;
    }
    else
    {
        timer.detach();
        counter=0;
        flag=0;
    }
}

void ButtonRight(void)
{
    StartHaptic();
    
    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    
    blueLed     = LED_ON;
}

void ButtonLeft(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_ON;
    blueLed     = LED_OFF;
}

void ButtonSlide(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_ON;
    blueLed     = LED_ON;
}

void StartHaptic(void)
{
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n) {
    haptic = 0;
    hapticTimer.stop();
}