#include "Si7021.h"

SI7021_I2C::SI7021_I2C(PinName sda, PinName scl) : i2c_(sda, scl) 
{    
    //400kHz, allowing us to use the fastest data rates.
    i2c_.frequency(400000);   
}

uint8_t SI7021_I2C::readBytes(uint8_t *values, int8_t length, bool waitConversion)
{
    uint8_t Status=0;

    if(!i2c_.write(SI7021_ADDR, (const char*)values, 1,0))
        Status=1;
    
    //Wait the measurement time
    if(waitConversion)
        wait_ms(23);
    
    if(!i2c_.read(SI7021_ADDR, (char*)values, length,0))
        Status=1;
    return(Status);
}


float SI7021_I2C::Measure_Temp(void)
{
    float Temperature;
    uint16_t ConvValue;
    uint8_t *Ptr;
    uint8_t Data[2];
    
    Data[0]=SI7021_MEASURE_TEMPERATURE_HOLD_MASTER;
    if(readBytes(Data,2, 1))
    {
        Ptr=(uint8_t*)&ConvValue;
        Ptr[0]=Data[1];
        Ptr[1]=Data[0];
        
        Temperature=(((float)ConvValue)/65536)*175-46.85;
    }
    else
    {
        Temperature=1234;
    }
    
    return(Temperature);
}

float SI7021_I2C::get_HumidityTemp(void)
{
    float Temperature;
    uint16_t ConvValue;
    uint8_t *Ptr;
    uint8_t Data[2];
    
    Data[0]=SI7021_READ_TEMPERATURE;
    if(readBytes(Data,2, 0))
    {
        Ptr=(uint8_t*)&ConvValue;
        Ptr[0]=Data[1];
        Ptr[1]=Data[0];
        
        Temperature=(((float)ConvValue)/65536)*175-46.85;
    }
    else
    {
        Temperature=1234;
    }
    
    return(Temperature);
}

void SI7021_I2C::Measure_Humidity_Temp(float *humidity, float *temperature)
{
    float Humidity;
    uint16_t ConvValueHum;
    uint8_t *Ptr;
    uint8_t Data[2];
    
    Data[0]=SI7021_MEASURE_RH_NO_HOLD_MASSTER;
    
    if(readBytes(Data,2, 1))
    {
    
        Ptr=(uint8_t*)&ConvValueHum;
        Ptr[0]=Data[1];
        Ptr[1]=Data[0];
        
        Humidity=(((float)ConvValueHum)/65536)*125-6;
        
        if(Humidity<0)
            Humidity=0;
        if(Humidity>100)
            Humidity=100;           
    }
    else
        Humidity=1234;  

    *humidity = Humidity;
    *temperature = get_HumidityTemp();
    
}
