#include "mbed.h"
#include "freemaster_class.h"
//Initialize FreeMASTER driver
Freemaster fm(USBTX, USBRX);

//Add global variables
volatile unsigned short var16;
volatile unsigned short var16inc = 100;

//Registration of all variables to observe in the FreeMASTER tool
FMSTR_TSA_TABLE_LIST_BEGIN()
//Register all TSA tables

FMSTR_TSA_TABLE_LIST_END()

int main() {
  //change baudrate to 9600
  fm.baud(9600);
  //register global or static variables to FreeMASTER driver
  fm.TsaAddVar(FMSTR_TSA_RW_VAR_CFG(var16inc, FMSTR_TSA_UINT16));
  //register read only variable to FreeMASTER driver
  fm.TsaAddVar(FMSTR_TSA_RO_VAR_CFG(var16,    FMSTR_TSA_UINT16));

  while(1) {
    //execute demo code
    var16+=var16inc;
    //sample variable by the Recorder feature
    fm.Recorder();
    wait(0.0025);
  }
}
