#define MBED_HEAP_STATS_ENABLED 1
#include <stdio.h>

#include "mbed.h"

#include <Console.h>

Serial pc(SERIAL_TX, SERIAL_RX, 115200);
DigitalOut myled(LED1);

#include "mbed_stats.h"

void worker(char *name)
{
	printf("%s started\r\n", name);
	wait(15);
	while(1)
	{
		printf("Tick from %s\r\n", name);
		wait(5);
	}
}


Console::cmd_list_t *Console::mCmdTable[] =
{
        (cmd_list_t*)shellCommands,
        0
};

int main()
{
	printf("Serial Console demo\n");


	Console::init(&pc, "led");

	while(1) {
	    //		printf("main tick\r\n");
	    myled = 1; // LED is ON
	    wait(0.2); // 200 ms
	    myled = 0; // LED is OFF
	    wait(1.0); // 1 sec
	}
}
