#include "mbed.h"

//Appearantly I cannot declare leds as volatile. I whish I could.
DigitalOut ledRed(LED_RED);
DigitalOut ledBlue(LED_BLUE);
DigitalOut ledGreen(LED_GREEN);

Serial pc(USBTX, USBRX, "YOLO");

Ticker ticker;

volatile bool red = false;
volatile bool green = false;
volatile bool blue = false;

void tick() {
    if (red) {
        ledRed = !ledRed;
    }
    if (green) {
        ledGreen = !ledGreen;
    }
    if (blue) {
        ledBlue = !ledBlue;
    }
}

int main()
{    
    ticker.attach(&tick, 1); //schedule the tick function to be executed every second.
    
    pc.baud(115200);
    pc.printf("Press 'r', 'g' or 'b' to toggle the RGB LEDs \r\n");
    
    while (true) {
        char c = pc.getc();
        switch(c) {
        case 'r':
            red = !red;
            break;
        case 'b':
            blue = !blue;
            break;
        case 'g':
            green = !green;
            break;
        }
    }
}