#include "mbed.h"
#include "QEI.h"

Serial pc(USBTX, USBRX);
InterruptIn reset_button(D2);

const float ratio = 1.0f/131.25f;

QEI qei(D13, D12, NC, 32);

Ticker printer;
volatile int seconds_passed = 0;

void onTick() {
    pc.printf("pulses = %d\r\n", qei.getPulses());
    pc.printf("revolutions = %d\r\n", qei.getRevolutions());
    pc.printf("angular velocity = %d degrees/second\r\n", (qei.getPulses() / ++seconds_passed) * (360/32));
    pc.printf("\n\n");
}

void reset() {
    seconds_passed = 0;
    qei.reset();
}

int main()
{
    pc.baud(115200);
    qei.reset();
    printer.attach(onTick, 1);
    reset_button.fall(reset); //there must be a better/cleaner way to do this.
    while (true);
}