#include "mbed.h"

PwmOut led(D3);

InterruptIn but1(D5);
InterruptIn but2(D4);

volatile float brightness = 0.0f;

void increaseBrightness() {
    brightness = brightness + 0.1f > 1.0f ? 1.0f : brightness + 0.1f;
    led.write(brightness);
}

void decreaseBrightness() {
    brightness = brightness - 0.1f < 0.0f ? 0.0f : brightness - 0.1f;   
    led.write(brightness);
}

int main()
{
    but1.fall(increaseBrightness);
    but2.fall(decreaseBrightness);
    while (true);
}