#include "mbed.h"
#include "tsi_sensor.h"

int  divisor = 10;      //set divisor, for blinking speed
float slider = 0;       //we need that later

/* This defines will be replaced by PinNames soon, it is needed to init the slider */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

int main(void)
{
    TSIAnalogSlider tsi(ELEC0, ELEC1, 80);      //init slider

    PwmOut ledGreen(LED_GREEN);                 //init led pwm channels
    PwmOut ledRed(LED_RED);
    PwmOut ledBlue(LED_BLUE);

    while (true) {

        if(tsi.readPercentage() != 0) {                 //check if slider is tuched, if tuched slider != 0
            slider = tsi.readPercentage()/divisor;      //set slidervalue ( / divisor )
        }

        ledGreen = 1;                           //turn led´s on and off
        ledRed = 0;
        wait(slider);                           //wait defined speed (slidervalue)

        ledRed = 1;
        ledBlue = 0;
        wait(slider);

        ledBlue = 1;
        ledGreen = 0;
        wait(slider);


    }
}


