#include "mbed.h"
#include "Servo.h"

I2CSlave slave(p9, p10);  //Configure I2C slave
PwmOut steering (p21);// Define PWM Output to wheels servo
Servo motor (p22); // Define PWM Output to the ESC
DigitalOut forward(LED1);
DigitalOut back(LED2);
DigitalOut stop(LED3);
DigitalOut led1(p13); // Indicator Light for center turn
DigitalOut led2(p15); //  Indicator Light for left turn
DigitalOut led3(p17);// Indicator Light for right turn
char switch_word ;    //word we will send
char recd_val;        //value received from master

int main() //start of main programme
{ 
    slave.address(0x52); // The slave is addressed
    while(1) 
    {
        led1=0;
        led2=0;
        led3=0;
        forward=0;
        back=0;
        stop=0;
        switch_word=0xa0;          //set up a recognisable output pattern
        slave.write(switch_word); //load up word to send
        /*test for I2C, and act accordingly*/
        int i = slave.receive();
        if (i == 3) //slave is addressed, Master will write
        {    
            recd_val= slave.read();
            recd_val=recd_val&0x0F; // AND out unwatnted LSB bits
            /*Locomotion and Sterring Control based on received Value*/
            if (recd_val==1)
            {
                led1=1;
                forward=1;
                steering.pulsewidth (0.0015); //centre
                wait(0.2);
                motor.write(0.3); //full forward
                wait(1);
            }
            /*
            if (recd_val==2)
            {
                led3=1;
                forward=1;
                steering.pulsewidth (0.0009);//right
                wait(0.2);
                motor.write(0.3); //full forward
                wait(1);
            }
            */
            if (recd_val==3)
            {
                led3=1;
                forward=1;
                steering.pulsewidth (0.0009);//right
                wait(0.2);
                motor.write(0.3);//forward
                wait(1);
            } 
            /*   
            if(recd_val==4)
            {
                led3=1;
                back=1;
                steering.pulsewidth (0.0009);//right
                wait(0.2);
                motor.write(0.6); //full backwards
                wait(1);
            }*/
            if (recd_val==5)
            {
                led1=1;
                back=1;
                steering.pulsewidth (0.0015);//center
                motor.write(0.6); //full backwards 
                wait(1);
            }
            /*
            if(recd_val==6)
            {
                led2=1;
                back=1;
                steering.pulsewidth (0.0021);//LEFT 
                wait(0.2);   
                motor.write(0.6); //full backwards 
                wait(1);
            }
            */           
            if (recd_val==7)
            {
                led2=1;
                forward=1;
                steering.pulsewidth (0.0021);//LEFT 
                wait(0.2);
                motor.write(0.3); //full forward
                wait(1);
                led1=0;
                led2=0;
                led3=0;
            }
            /*
            if (recd_val==8)
            {
                led2=1;
                forward=1;
                steering.pulsewidth (0.0021);//LEFT 
                wait(0.2);
                motor.write(0.3); //full FORWARD
                wait(1);
            }
            */
            if (recd_val==9)
            {
                 stop=1;
                 steering.pulsewidth(0.0015);//stop
                 wait(0.2);
                 motor.write(0.5);//stop
                 wait(1);
            }
            if (recd_val==0)
            {
                 stop=1;
                 steering.pulsewidth(0.0015);//stop
                 wait(0.2);
                 motor.write(0.5);//stop
                 wait(1);
            }
        }  
    }  
}
