//Define the file once, in the C and C++ programming languages, an #include guard,is a particular construct used to 
//avoid the problem of double inclusion when dealing with the include directive. The addition of #include guards to a header file is one way to make that file idempotent.
#ifndef FUNCDEF_H
#define FUNCDEF_H

//Import Modules
#include <mbed.h>

//Set up PC link (comment out when not using), set up 9600 if using plotter
static Serial pc = Serial(USBTX, USBRX);

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Pin Names
#define leftMotorpin D6
#define rightMotorpin D1
#define beeperPin D10

#define Kp 90//80//110
#define Ki 0 //0.004
#define Kd 0 //32
#define Ac 100

//i=0.05 to high
//values that work, p=55   ,i=0.003,d=0,motorcurve=normal, initial speed=250, fast 300seconds, middle hole

//values that work, p=45   ,i=0.005,d=0,motorcurve=normal, initial speed=250, fast 300seconds, middle hole

//

#define calibrationMotorspeed 410

//http://www.sengpielaudio.com/calculator-notenames.htm

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Pin Definitions
static DigitalOut LEDVal = DigitalOut(LED1);
static DigitalOut CountingVar = DigitalOut(D0);
static PwmOut leftMotorVal=PwmOut(leftMotorpin);
static PwmOut rightMotorVal=PwmOut(rightMotorpin);

static AnalogIn sensorPin[] = {A0,A1,A2,A3,A4,A5,A6,D3};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Global Variable Definitions
extern int sensorValue[8];

extern int sensorMinValue[8];
extern int sensorMaxValue[8];

extern int sensorMinValue1[8];
extern int sensorMaxValue1[8];

extern int sensorMinValue2[8];
extern int sensorMaxValue2[8];

extern int sensorThreshold[8];
extern int sensorErrorsdiscrete[8];
extern float sensorErrors[8];

extern float linearOffset[106][2];
extern float motorLookup[11][2];

extern float Prop;
extern float Inte;
extern float Dere;

extern float errorVar;
extern float largestpositiveerrorvar;
extern float largestnegativeerrorvar;
extern float previousError;
extern int errorVardiscrete;
extern int previousErrordiscrete; 
extern float PIDs;
extern int newPIDs;
extern int initialMotorspeed;
extern int leftMotorValTemp;
extern int rightMotorValTemp;
extern int accumulator;
extern bool stopMotors;
extern int errorDetectthres;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Function Definitions

void CalibrateFunc(void);
void senseFunc(void);
void calculateFunc(void);
void driveFunc(void);
void findLineFunc(void);

#endif // FUNCDEF_H