#include "Display.h"
extern int timer; //Stores timer mode
extern int Time;  //time in 10mS

                  //A    B    C    d    E    F    g    H    I    J    K    L    M    N    O    P    q    r    S    t    U    V    W    X    y    Z
int ImageTable[26]={0x77,0x1F,0x4E,0x3D,0x4F,0x47,0x7B,0x37,0x30,0x3C,0x37,0x0E,0x00,0x76,0x7E,0x67,0x73,0x46,0x5B,0x0F,0x3E,0x3E,0x00,0x37,0x3B,0x6D};

DigitalOut CS           (D2);
SPI Display( PTD2,PTD3,PTD1);
    
void DisplayInit(void){
    CS =1;                     //Disable chip select
    Display.format(16,3);      //16-bit, mode 3
    Display.frequency(1000000);//1MHz clock speed
    SendData(0x01, ShutDown ); //Normal Operation
    SendData(0x0F, Intensity); //Brightness set to full
    SendData(0x04, ScanLimit); //Scanning digits 1-5
    DisplayBCD(1);             //BCD decoder active on all digits
}

void SendData(int data, int address){
    
    CS=0;               //Enable input
    data|=(address<<8); //Data format: XXXXAAAADDDDDDDD, X=dont care. A=address. D=data
    Display.write(data);//Send SPI data
    CS=1;               //Disable input
    
}

void DisplayClear(void){//Only use when not in BCD mode.
    
    SendData(0x00,1);   //Send nothing to all the digits.
    SendData(0x00,2);
    SendData(0x00,3);
    SendData(0x00,4);
    SendData(0x00,5);
    
}

void DisplayBCD(int state){//1 to turn on, 0 to turn off.
    if(state){
        SendData(0xFF, BCD_Mode); 
    }else{
        SendData(0x00, BCD_Mode); 
    }
}

void DisplayUpdate(void){

    if      (timer==Start){ //If timer is in start mode, increment the time
        Time++;
    }else if(timer==Reset){ //If timer is on reset mode, time = 0
        Time=0;
    }
    
    if(timer!=Disable){           //Display the time on the 7-segment display, if enabled.
        DisplayBCD(1);
        SendData(DPoint| (Time/6000)      , 5);
        SendData(       ((Time%6000)/1000), 4);
        SendData(DPoint|((Time%1000)/100) , 1);
        SendData(       ((Time%100 )/10)  , 2);
        SendData(       ((Time%10  )  )   , 3);
    }
}

void DisplayScroll(char data[40]){//Lower case only
    int ScreenText[50]; //Segment data for screen
    int n,length;
    
    for(n=0;n<50;n++){  //clear array
        ScreenText[n]=0;
    }
    
    n=0;
    while(n<40 && (data[n]!='\0')){                 //keep looping untill the end of the string, max 20
        if(data[n]>96 && data[n]<123){              //check for valid characters
            ScreenText[n+5]=ImageTable[data[n]-97]; //use a look-up table to convert ASCII to segment data
        }
        n++;    
    }
    
    timer=Disable;
    DisplayBCD(0);  //turn off decoders
    
    length=n;
    for(n=0;n<(length+6);n++){  //display data
        SendData(ScreenText[n  ], 5);
        SendData(ScreenText[n+1], 4);
        SendData(ScreenText[n+2], 1);
        SendData(ScreenText[n+3], 2);
        SendData(ScreenText[n+4], 3);
        wait(0.3);
    }  
}

void DisplayNumber(char n1,char n2,char n3,char n4,char n5){
    
    timer=Disable;
    DisplayBCD(1);  //turn off decoders

    SendData(n1, 5);
    SendData(n2, 4);
    SendData(n3, 1);
    SendData(n4, 2);
    SendData(n5, 3);
}
