// Juntando a programação do sensor de fluxo com o acelerômetro
// por Thiago

// Criado dia 02/03/2015
//

#include "mbed.h"

/*-------ADXL345-------*/

// When SDO grounded
#define ADXL1_ADDR_WRITE 0xA6
#define ADXL1_ADDR_READ 0xA7
#define ADXL1_ADDR 0X53

//When SDO high
#define ADXL2_ADDR_WRITE 0x3A
#define ADXL2_ADDR_READ 0x3B
#define ADXL2_ADDR 0x53

//Registers

#define POWER_CTL 0x2D
#define DATA_FORMAT 0x31
#define DATAX0 0x32
#define DATAX1 0x33
#define DATAY0 0x34
#define DATAY1 0x35
#define DATAZ0 0x36
#define DATAZ1 0x37
#define OFSX 0x1D
#define OFSY 0x1F
#define OFSZ 0x20
#define BW_RATE 0x2C

/*----Transmicao----*/

I2C i2c(PTC2,PTC1);    
Serial pc(USBTX,USBRX);

/*-----Funcoes------*/

// Acelerômetro:
int RegisterWrite(char,char,char);
int RegisterRead(char,char);
inline void MultByteRead(char,char,char*,int);
void GetOutput(char,int*);

// Sensor de Fluxo:
AnalogIn ain(PTB3);
DigitalOut led2(LED2);  // Led red
void HandlerT1(void);
void rx_Handler(void);

Ticker t1;              // Timer to send data

volatile bool STATUS = true;
char test = 0;

int main()
{

/*-----------------INICIALIZA SENSOR DE FLUXO-----------*/
    pc.baud(9600);
    pc.attach(&rx_Handler, pc.RxIrq);
    led2=0;


/*------------------INICIALIZA ACELEROMETRO-------------*/
int readings[3] = {0,0,0};
    printf("Entrou no main");   //Debug.
    
    i2c.frequency(100000);  //100kHz

// Testa Envio:
    pc.printf("Sending POWER CONTROL\t");
    STATUS = RegisterWrite(ADXL1_ADDR,POWER_CTL,0x00);

     if (STATUS != 0){
      pc.printf("WRITE NO SUCCESS\t");
     }
    else{
      pc.printf("ACKNOLEDGE RECEIVED");
     }

    wait(0.1);
      pc.printf("Sending Data Format\t");

    RegisterWrite(ADXL1_ADDR,DATA_FORMAT,0x09); // 

    RegisterWrite(ADXL1_ADDR,BW_RATE,0x0A);     // Default Value... 100kHZ

    RegisterWrite(ADXL1_ADDR,POWER_CTL,0x08);   // MeasurementMode
    

/*-------------Setting the Offset Value---------------*/

    RegisterWrite(ADXL1_ADDR,OFSX,0xFD);
    RegisterWrite(ADXL1_ADDR,OFSY,0x03);
    RegisterWrite(ADXL1_ADDR,OFSZ,0xFE);

/*----------------------------------------------------*/

    wait(0.1);
    printf("Now, trying to read data\t");
    printf("%i", RegisterRead(ADXL1_ADDR,0x00));
    
    if (STATUS == 0){
      printf("READ SUCCESSFULL\t");
    }
    else {
      printf("READ NOT SUCCESSFUL\n");
    }    
        
    pc.printf("Press 2 to Start");

    while(1) {

        wait(0.5);                                  // Debug
        led2 = 0;
        pc.putc(test);                             // Debug

        if (test == '2') {
            t1.attach(&HandlerT1, 0.01);
        }

        while(test == '2') {

            if (STATUS == true) {

                STATUS = false;
                led2 = 1;
                pc.printf("0x%04X",ain.read_u16());
            GetOutput(ADXL1_ADDR,readings);
            pc.printf("%i,%i,%i\n",(int16_t)readings[0],(int16_t)readings[1],(int16_t)readings[2]);
         }


        } //end of while(test=='2'){}

        t1.detach();    // Detaches timer interruption when not needed
    }//end of while(1)
}//end of main

void HandlerT1(void)
{
    STATUS = true;
}

void rx_Handler(void)
{
    test = pc.getc();
    pc.putc(test);
}

int RegisterWrite(char SLAVE, char RegAddress, char Data){
    char cmd[2];
    cmd[0]= RegAddress;
    cmd[1]= Data;
    int ack = i2c.write((SLAVE<<1),cmd,2);
    return ack;
    }
    
int RegisterRead(char SLAVE, char address){
    char output;
    char tx = address; 
    i2c.write((SLAVE<<1),&tx,1);
    STATUS = i2c.read((SLAVE<<1), &output,1);
    return output;
    } 
    
inline void MultRegisterRead(char SLAVE, char address,char*output,int size){
    i2c.write((SLAVE<<1),&address,1);
    i2c.read((SLAVE<<1),output,size);
    return;    
    }

void GetOutput(char SLAVE, int* readings){
    char buffer[6];
    MultRegisterRead(SLAVE,DATAX0,buffer, 6);
    readings[0] = (int)buffer[1] << 8 | (int)buffer[0];
    readings[1] = (int)buffer[3] << 8 | (int)buffer[2];
    readings[2] = (int)buffer[5] << 8 | (int)buffer[4];        
    }