#include "mbed.h"
#include <stdio.h>
#include <string.h>
#include "hcsr04.h"

Serial pc(USBTX,USBRX);
//Serial UART(USBTX,USBRX);
HCSR04  usensor(D8,D12);
//Bluetooth module declaration
Serial blue(PTC15, PTC14);
DigitalOut Redl(LED1);
DigitalOut Bluel(LED3);
DigitalOut Greenl(LED2);

DigitalOut vibMotorR(D3);
DigitalOut vibMotorL(D5);

int c =0;
unsigned int dist;
char a;
char k;
Timer dt;
int main()
{
    pc.baud(9600);
    dt.start();
    Greenl = 1; //FRDM LED initially OFF
    Bluel = 1; //FRDM LED initially OFF
    Redl = 1; //FRDM LED initially OFF
    vibMotorL = 0;
    vibMotorR = 0;
    while(1)
    {
        usensor.start();
        wait_ms(500);
        dist=usensor.get_dist_cm();
        printf("\n\r cm:%ld",dist);
        dt.reset();
        k = 'F';
        if(blue.readable()> 0)
        {
            c = blue.getc();
            pc.printf("\n\rbluetooth");
            pc.printf("\n\r %ld",c);
            k = 'T';
            }
            if(dist>1 and dist<=30)
            {
                pc.printf("case1: Obstacle ahead\r\n");
                pc.printf("\n\r %ld",dist);
                blue.printf("1");
                Redl = 0;
                vibMotorL = 1;
                vibMotorR = 1;
                wait(3);
                Redl = 1;
                vibMotorL = 0;
                vibMotorR = 0;
                }
                if (k == 'T')
                {
                    if (c == 49)
                    {
                        pc.printf("case 2: Turn Left\r\n");
                        Greenl = 0;
                        vibMotorL = 1;
                        wait(3);
                        Greenl = 1;
                        vibMotorL = 0;
                        k = 'F';
                        }
                        else if (c == 50)
                        {
                            pc.printf("case 3: Turn Right\r\n");
                            Bluel = 0;
                            vibMotorR = 1;
                            wait(3);
                            Bluel = 1;
                            vibMotorR = 0;
                            k = 'F';
                            }
                            else if (c == 51)
                            {
                                pc.printf("case 4: Destination reached\r\n");
                                Bluel = 0;
                                Greenl = 0;
                                Redl = 0;
                                vibMotorL = 1;
                                vibMotorR = 1;
                                wait(3);
                                Bluel = 1;
                                Greenl = 1;
                                Redl = 1;
                                vibMotorL = 0;
                                vibMotorR = 0;
                                wait(1);
                                Bluel = 0;
                                Greenl = 0;
                                Redl = 0;
                                vibMotorL = 1;
                                vibMotorR = 1;
                                wait(3);
                                Bluel = 1;
                                Greenl = 1;
                                Redl = 1;
                                vibMotorL = 0;
                                vibMotorR = 0;
                                k = 'F';
                                }
                                }
                                }
                                }