#include "mbed.h"
#include "USBSerial.h"


//USB Serial / malloc functions
void mallocRead(void);
void serCallback(void);
void dumpSerial(void);
USBSerial ser;

#define BUFLENG 16
char *charbuf;                  //malloc pointer
char *bufstart;                 //malloc start
bool bufOverun = false;

int main() {
    charbuf = (char *)malloc(BUFLENG);      //sets up malloc
    bufstart = charbuf;                     //sets pointer start variable
    memset(bufstart, 'A', BUFLENG);         //fills buffer with A
    /*
    for(int i=0; i<BUFLENG; i++){
        *charbuf = (char)'A';
        charbuf++;
    }*/
    //charbuf = bufstart;
    wait_ms(1000);
    
    ser.attach(serCallback);                //attaches USB Serial callback function
    ser.printf("Serial USB begin with malloc buffer \n\n");         //startup message
    
    while(1) {
        mallocRead();           //reads the malloc once every second
        wait_ms(1000);
    }
}


//serial 
void serCallback(void) {
    int bufin = ser.available();                                //gets the length of the serial to read
    if(bufin <= (BUFLENG - (charbuf - bufstart))) {             //checks to see if the buffer is long enough
        for(int i=0; i<bufin; i++){                             //collects each char to read
            *charbuf = (char)ser._getc();                       //adds char to malloc
            charbuf++;                                          //increments pointer
        }
    }
    else {
        dumpSerial();           //if the malloc is not big enough the serial data will be dumped
    }
}


void mallocRead(void) {
    for(int i=0; i<BUFLENG; i++){                   //increments through the whole buffer, printing the chars
        ser.printf("%c", bufstart[i]);
    }
    if(bufOverun) {
        ser.printf("\tDATA LOST buffer over ran");      //lets the user know that the buffer was exceded
        bufOverun = false;                              //resets buffer over run boolean
    }
    ser.printf("\n");
    charbuf = bufstart;             //sets the pointer back to the start of the buffer
}


void dumpSerial(void) {
    while(ser.readable()){
            ser._getc();            //dumps the buffer one char at a time while the buffer is full
        }
        bufOverun = true;
    }
}