





#ifndef SPIMEM_H
#define SPIMEM_H

#include "mbed.h"



#define WREN 0x06
#define WRDI 0x04
#define RDSR 0x05
#define WRSR 0x01
#define READ 0x03
#define WRITE 0x02

#define PAGE_SIZE 32


class SPIMem {
public:

    SPIMem(PinName _mosi, PinName _miso, PinName _sckl, PinName _cs);
    
    void writeEnable(void);
    void writeDisable(void);
    
    void write(uint16_t addr, uint8_t val);
    int read(uint16_t addr);
    
    void burstWrite(uint16_t addr, char *data, uint16_t len);
    void burstRead(uint16_t addr, char *data, uint16_t len);
    
    
    
private:
    SPI spi;
    DigitalOut cs;
};

#endif