

#include "SPIMem.h"


SPIMem::SPIMem(PinName _mosi, PinName _miso, PinName _sckl, PinName _cs) : spi(_mosi, _miso, _sckl), cs(_cs) {
    cs = 1;
    
    spi.frequency(20000000);
}

void SPIMem::writeEnable(void) {
    cs = 0;
    spi.write(WREN);
    cs = 1;
}

void SPIMem::writeDisable(void) {
    cs = 0;
    spi.write(WRDI);
    cs = 1;
}

void SPIMem::write(uint16_t addr, uint8_t val) {
    writeEnable();
    
    cs = 0;
    spi.write(WRITE);
    spi.write((uint8_t)(addr >> 8));
    spi.write((uint8_t)addr);
    spi.write(val);
    cs = 1;
}

int SPIMem::read(uint16_t addr) {
    cs = 0;
    spi.write(READ);
    spi.write((uint8_t)(addr >> 8));
    spi.write((uint8_t)addr);
    int data = spi.write(0x00);
    cs = 1;
    
    return data;
}

void SPIMem::burstWrite(uint16_t addr, char *data, uint16_t len) {
    writeEnable();
    
    cs = 0;
    spi.write(WRITE);
    spi.write((uint8_t)(addr >> 8));
    spi.write((uint8_t)addr);
    for(int i=0; i<len; i++) {
        spi.write(data[i]);
    }
    cs = 1;
}