/* Library for interfacing to the M95*** SPI EEPROM module

    - 13/02/19 - Basic Start 






Enjoy
*/


#ifndef M95256_H
#define M95256_H

#include "mbed.h"



#define WREN 0x06
#define WRDI 0x04
#define RDSR 0x05
#define WRSR 0x01
#define READ 0x03
#define WRITE 0x02


//WRITE | 16 bit address | 8 bit data
//READ | 16 bit address         returns | 8 bit data


class M95256: public SPI {
public:
    
    // _spi - pointer to SPI 
    // memsize - size of memory in KB
    M95256(PinName mosi, PinName miso, PinName sckl, PinName cs, uint16_t memsize, int freq = 1000000) : SPI(mosi, miso, sckl, cs) {
        SPI::frequency(freq);
        memorysize = memsize;
    }
    
    bool writeRegister(uint16_t reg, uint8_t val) {
        writeEnable();
    
        SPI::lock();
        SPI::write(WRITE);
        SPI::write(reg);
        SPI::write(val);
        SPI::unlock();
    
        writeDisable();
        return 1;
    }
    
    uint8_t readRegister(uint16_t reg) {
        uint8_t readBuf;
    
        SPI::lock();
        SPI::write(READ);
        readBuf = SPI::write(reg);
        SPI::unlock();
    
        return readBuf;
    }
    
    
protected:
    void writeEnable(void) {
        SPI::lock();
        SPI::write(WREN);
        SPI::unlock();
    }
    
    void writeDisable(void) {
        SPI::lock();
        SPI::write(WRDI);
        SPI::unlock();
    }
    
private:
    uint16_t memorysize;
};

#endif